/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.paint.Paint;
import com.sun.prism.shape.ShapeRep;

public abstract class NGShape
extends NGNode
implements PGShape {
    protected Paint fillPaint;
    protected Paint drawPaint;
    protected BasicStroke drawStroke;
    protected PGShape.Mode mode = PGShape.Mode.FILL;
    protected ShapeRep shapeRep;
    private static final int[] coordsPerSeg = new int[]{2, 2, 4, 6, 0};
    static final int AT_IDENT = 0;
    static final int AT_TRANS = 1;
    static final int AT_GENERAL = 2;

    @Override
    public void setMode(PGShape.Mode mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.geometryChanged();
        }
    }

    @Override
    public void setAntialiased(boolean bl) {
    }

    @Override
    public void setFillPaint(Object object) {
        if (object != this.fillPaint) {
            this.fillPaint = (Paint)object;
            this.visualsChanged();
        }
    }

    @Override
    public void setDrawPaint(Object object) {
        if (object != this.drawPaint) {
            this.drawPaint = (Paint)object;
            this.visualsChanged();
        }
    }

    @Override
    public void setDrawStroke(float f, PGShape.StrokeType strokeType, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f2, float[] fArray, float f3) {
        int n = strokeType == PGShape.StrokeType.CENTERED ? 0 : (strokeType == PGShape.StrokeType.INSIDE ? 1 : 2);
        int n2 = strokeLineCap == PGShape.StrokeLineCap.BUTT ? 0 : (strokeLineCap == PGShape.StrokeLineCap.SQUARE ? 2 : 1);
        int n3 = strokeLineJoin == PGShape.StrokeLineJoin.BEVEL ? 2 : (strokeLineJoin == PGShape.StrokeLineJoin.MITER ? 0 : 1);
        if (this.drawStroke == null) {
            this.drawStroke = new BasicStroke(n, f, n2, n3, f2);
        } else {
            this.drawStroke.set(n, f, n2, n3, f2);
        }
        if (fArray.length > 0) {
            this.drawStroke.set(fArray, f3);
        } else {
            this.drawStroke.set(null, 0.0f);
        }
        this.geometryChanged();
    }

    public abstract Shape getShape();

    protected ShapeRep createShapeRep(Graphics graphics, boolean bl) {
        return graphics.getResourceFactory().createPathRep(bl);
    }

    @Override
    protected void renderContent(Graphics graphics) {
        boolean bl;
        if (this.mode == PGShape.Mode.EMPTY) {
            return;
        }
        boolean bl2 = bl = !graphics.getTransformNoClone().is2D();
        if (this.shapeRep == null) {
            this.shapeRep = this.createShapeRep(graphics, bl);
        } else if (bl && !this.shapeRep.is3DCapable()) {
            this.shapeRep.dispose();
            this.shapeRep = this.createShapeRep(graphics, true);
        }
        Shape shape = this.getShape();
        if (this.mode != PGShape.Mode.STROKE) {
            graphics.setPaint(this.fillPaint);
            this.shapeRep.fill(graphics, shape);
        }
        if (this.mode != PGShape.Mode.FILL && this.drawStroke.getLineWidth() > 0.0f) {
            graphics.setPaint(this.drawPaint);
            graphics.setStroke(this.drawStroke);
            this.shapeRep.draw(graphics, shape);
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return this.mode == PGShape.Mode.STROKE_FILL;
    }

    protected Shape getStrokeShape() {
        return this.drawStroke.createStrokedShape(this.getShape());
    }

    @Override
    protected void geometryChanged() {
        super.geometryChanged();
        if (this.shapeRep != null) {
            this.shapeRep.invalidate(ShapeRep.InvalidationType.LOCATION_AND_GEOMETRY);
        }
    }

    void locationChanged() {
        super.geometryChanged();
        if (this.shapeRep != null) {
            this.shapeRep.invalidate(ShapeRep.InvalidationType.LOCATION);
        }
    }

    static BaseBounds getRectShapeBounds(BaseBounds baseBounds, BaseTransform baseTransform, int n, float f, float f2, RectBounds rectBounds) {
        if (baseBounds == null) {
            baseBounds = new RectBounds();
        }
        float f3 = rectBounds.getWidth();
        float f4 = rectBounds.getHeight();
        if (f3 < 0.0f || f4 < 0.0f) {
            return baseBounds.makeEmpty();
        }
        float f5 = rectBounds.getMinX();
        float f6 = rectBounds.getMinY();
        if (n <= 1) {
            f3 += f5;
            f4 += f6;
            if (n == 1) {
                float f7 = (float)baseTransform.getMxt();
                float f8 = (float)baseTransform.getMyt();
                f5 += f7;
                f6 += f8;
                f3 += f7;
                f4 += f8;
            }
            f2 += f;
        } else {
            f5 -= f;
            f6 -= f;
            f3 += f * 2.0f;
            f4 += f * 2.0f;
            float f9 = (float)baseTransform.getMxx();
            float f10 = (float)baseTransform.getMxy();
            float f11 = (float)baseTransform.getMyx();
            float f12 = (float)baseTransform.getMyy();
            float f13 = f5 * f9 + f6 * f10 + (float)baseTransform.getMxt();
            float f14 = f5 * f11 + f6 * f12 + (float)baseTransform.getMyt();
            f5 = Math.min(Math.min(0.0f, f9 *= f3), Math.min(f10 *= f4, f9 + f10)) + f13;
            f6 = Math.min(Math.min(0.0f, f11 *= f3), Math.min(f12 *= f4, f11 + f12)) + f14;
            f3 = Math.max(Math.max(0.0f, f9), Math.max(f10, f9 + f10)) + f13;
            f4 = Math.max(Math.max(0.0f, f11), Math.max(f12, f11 + f12)) + f14;
        }
        return baseBounds.deriveWithNewBounds(f5 -= f2, f6 -= f2, 0.0f, f3 += f2, f4 += f2, 0.0f);
    }

    static BaseBounds getRectShapeBounds(BaseBounds baseBounds, BaseTransform baseTransform, int n, float f, float f2, RectangularShape rectangularShape) {
        if (baseBounds == null) {
            baseBounds = new RectBounds();
        }
        float f3 = rectangularShape.getWidth();
        float f4 = rectangularShape.getHeight();
        if (f3 < 0.0f || f4 < 0.0f) {
            return baseBounds.makeEmpty();
        }
        float f5 = rectangularShape.getX();
        float f6 = rectangularShape.getY();
        if (n <= 1) {
            f3 += f5;
            f4 += f6;
            if (n == 1) {
                float f7 = (float)baseTransform.getMxt();
                float f8 = (float)baseTransform.getMyt();
                f5 += f7;
                f6 += f8;
                f3 += f7;
                f4 += f8;
            }
            f2 += f;
        } else {
            f5 -= f;
            f6 -= f;
            f3 += f * 2.0f;
            f4 += f * 2.0f;
            float f9 = (float)baseTransform.getMxx();
            float f10 = (float)baseTransform.getMxy();
            float f11 = (float)baseTransform.getMyx();
            float f12 = (float)baseTransform.getMyy();
            float f13 = f5 * f9 + f6 * f10 + (float)baseTransform.getMxt();
            float f14 = f5 * f11 + f6 * f12 + (float)baseTransform.getMyt();
            f5 = Math.min(Math.min(0.0f, f9 *= f3), Math.min(f10 *= f4, f9 + f10)) + f13;
            f6 = Math.min(Math.min(0.0f, f11 *= f3), Math.min(f12 *= f4, f11 + f12)) + f14;
            f3 = Math.max(Math.max(0.0f, f9), Math.max(f10, f9 + f10)) + f13;
            f4 = Math.max(Math.max(0.0f, f11), Math.max(f12, f11 + f12)) + f14;
        }
        return baseBounds.deriveWithNewBounds(f5 -= f2, f6 -= f2, 0.0f, f3 += f2, f4 += f2, 0.0f);
    }

    private static void accumulate(float[] fArray, Shape shape, BaseTransform baseTransform) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            RectBounds rectBounds = shape.getBounds();
            if (fArray[0] > rectBounds.getMinX()) {
                fArray[0] = rectBounds.getMinX();
            }
            if (fArray[1] > rectBounds.getMinY()) {
                fArray[1] = rectBounds.getMinY();
            }
            if (fArray[2] < rectBounds.getMaxX()) {
                fArray[2] = rectBounds.getMaxX();
            }
            if (fArray[3] < rectBounds.getMaxY()) {
                fArray[3] = rectBounds.getMaxY();
            }
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(baseTransform);
        float[] fArray2 = new float[6];
        while (!pathIterator.isDone()) {
            int n = coordsPerSeg[pathIterator.currentSegment(fArray2)];
            for (int i = 0; i < n; ++i) {
                int n2 = i & 1;
                float f = fArray2[i];
                if (fArray[n2 + 0] > f) {
                    fArray[n2 + 0] = f;
                }
                if (!(fArray[n2 + 2] < f)) continue;
                fArray[n2 + 2] = f;
            }
            pathIterator.next();
        }
    }

    static int classify(BaseTransform baseTransform) {
        if (baseTransform == null) {
            return 0;
        }
        switch (baseTransform.getType()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    static boolean shapeContains(float f, float f2, NGShape nGShape, Shape shape) {
        PGShape.Mode mode = nGShape.mode;
        if (mode == PGShape.Mode.EMPTY) {
            return false;
        }
        if (mode != PGShape.Mode.STROKE && shape.contains(f, f2)) {
            return true;
        }
        if (mode != PGShape.Mode.FILL) {
            return nGShape.getStrokeShape().contains(f, f2);
        }
        return false;
    }
}

