/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.BaseCacheFilter;
import com.sun.javafx.sg.BaseEffectFilter;
import com.sun.javafx.sg.BaseNode;
import com.sun.javafx.sg.BaseNodeEffectInput;
import com.sun.javafx.sg.DirtyRegionContainer;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NodeEffectInput;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;

public abstract class NGNode
extends BaseNode<Graphics> {
    private static Boolean offscreenSupported;
    private static final GraphicsPipeline pipeline;
    private static final Boolean effectsSupported;

    NGNode() {
    }

    @Override
    protected void markCullRegions(DirtyRegionContainer dirtyRegionContainer, int n, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        RectBounds rectBounds;
        if (baseTransform.isIdentity()) {
            TEMP_BOUNDS.deriveWithNewBounds(this.transformedBounds);
        } else {
            baseTransform.transform(this.transformedBounds, TEMP_BOUNDS);
        }
        if (generalTransform3D != null && !generalTransform3D.isIdentity()) {
            generalTransform3D.transform(TEMP_BOUNDS, TEMP_BOUNDS);
        }
        TEMP_BOUNDS.deriveWithNewBounds(TEMP_BOUNDS.getMinX(), TEMP_BOUNDS.getMinY(), 0.0f, TEMP_BOUNDS.getMaxX(), TEMP_BOUNDS.getMaxY(), 0.0f);
        this.cullingBits = 0;
        int n2 = 3;
        for (int i = 0; i < dirtyRegionContainer.size() && (rectBounds = dirtyRegionContainer.getDirtyRegion(i)) != null && !rectBounds.isEmpty(); ++i) {
            if (n == -1 || (n & n2) != 0) {
                this.setCullBits(TEMP_BOUNDS, i, rectBounds);
            }
            n2 <<= 2;
        }
        if (this.cullingBits == 0 && (this.dirty || this.childDirty)) {
            this.clearDirtyTree();
        }
        if (this.debug) {
            System.out.printf("%s bits: %s bounds: %s\n", this, Integer.toBinaryString(this.cullingBits), TEMP_BOUNDS);
        }
    }

    @Override
    public void drawCullBits(Graphics graphics) {
        if (this.cullingBits == 0) {
            graphics.setPaint(new Color(0.0f, 0.0f, 0.0f, 0.3f));
        } else {
            graphics.setPaint(new Color(0.0f, 1.0f, 0.0f, 0.3f));
        }
        graphics.fillRect(this.transformedBounds.getMinX(), this.transformedBounds.getMinY(), this.transformedBounds.getWidth(), this.transformedBounds.getHeight());
    }

    @Override
    protected void doRender(Graphics graphics, RectBounds rectBounds, BaseTransform baseTransform) {
        boolean bl = false;
        if (PrismSettings.dirtyOptsEnabled && graphics.hasPreCullingBits()) {
            if ((this.cullingBits & 3 << graphics.getClipRectIndex() * 2) == 0) {
                return;
            }
            if ((this.cullingBits & 2 << graphics.getClipRectIndex() * 2) != 0) {
                graphics.setHasPreCullingBits(false);
                bl = true;
            }
        }
        graphics.setDepthTest(this.isDepthTest());
        BaseTransform baseTransform2 = graphics.getTransformNoClone();
        double d = baseTransform2.getMxx();
        double d2 = baseTransform2.getMxy();
        double d3 = baseTransform2.getMxz();
        double d4 = baseTransform2.getMxt();
        double d5 = baseTransform2.getMyx();
        double d6 = baseTransform2.getMyy();
        double d7 = baseTransform2.getMyz();
        double d8 = baseTransform2.getMyt();
        double d9 = baseTransform2.getMzx();
        double d10 = baseTransform2.getMzy();
        double d11 = baseTransform2.getMzz();
        double d12 = baseTransform2.getMzt();
        graphics.transform(this.getTransform());
        if (graphics instanceof ReadbackGraphics && this.needsBlending()) {
            this.renderNodeBlendMode(graphics);
        } else if (this.getClipNode() != null) {
            this.renderClip(graphics);
        } else if (this.getOpacity() < 1.0f) {
            this.renderOpacity(graphics);
        } else if (this.getCacheFilter() != null) {
            this.renderCached(graphics);
        } else if (this.getEffectFilter() != null && effectsSupported.booleanValue()) {
            this.renderEffect(graphics);
        } else {
            this.renderContent(graphics);
        }
        if (bl) {
            graphics.setHasPreCullingBits(true);
        }
        graphics.setTransform3D(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    private void renderContent3d(Graphics graphics) {
        FilterContext filterContext = NGNode.getFilterContext(graphics);
        BaseBounds baseBounds = this.getContentBounds(new RectBounds(), BaseTransform.IDENTITY_TRANSFORM);
        Rectangle rectangle = new Rectangle(baseBounds);
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle.width, rectangle.height);
        if (prDrawable == null) {
            return;
        }
        Graphics graphics2 = prDrawable.createGraphics();
        graphics2.translate(-rectangle.x, -rectangle.y);
        this.renderContent(graphics2);
        graphics.drawTexture(prDrawable.getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Effect.releaseCompatibleImage(filterContext, prDrawable);
    }

    protected boolean needsBlending() {
        Blend.Mode mode = this.getNodeBlendMode();
        return mode != null && mode != Blend.Mode.SRC_OVER;
    }

    private void renderNodeBlendMode(Graphics graphics) {
        BaseTransform baseTransform = graphics.getTransformNoClone();
        BaseBounds baseBounds = this.getClippedBounds(new RectBounds(), baseTransform);
        if (baseBounds.isEmpty()) {
            this.clearDirtyTree();
            return;
        }
        if (!this.isReadbackSupported(graphics)) {
            if (this.getClipNode() != null) {
                this.renderClip(graphics);
            } else if (this.getOpacity() < 1.0f) {
                this.renderOpacity(graphics);
            } else {
                this.renderContent(graphics);
            }
            return;
        }
        Rectangle rectangle = new Rectangle(baseBounds);
        rectangle.intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        FilterContext filterContext = NGNode.getFilterContext(graphics);
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle.width, rectangle.height);
        if (prDrawable == null) {
            this.clearDirtyTree();
            return;
        }
        Graphics graphics2 = prDrawable.createGraphics();
        graphics2.setHasPreCullingBits(graphics.hasPreCullingBits());
        graphics2.setClipRectIndex(graphics.getClipRectIndex());
        graphics2.translate(-rectangle.x, -rectangle.y);
        graphics2.transform(baseTransform);
        if (this.getClipNode() != null) {
            this.renderClip(graphics);
        } else if (this.getOpacity() < 1.0f) {
            this.renderOpacity(graphics2);
        } else if (this.getCacheFilter() != null) {
            this.renderCached(graphics2);
        } else if (this.getEffectFilter() != null) {
            this.renderEffect(graphics2);
        } else {
            this.renderContent(graphics2);
        }
        RTTexture rTTexture = ((ReadbackGraphics)graphics).readBack(rectangle);
        PrDrawable prDrawable2 = PrDrawable.create(filterContext, rTTexture);
        Blend blend = new Blend(this.getNodeBlendMode(), new PassThrough(prDrawable2, rectangle), new PassThrough(prDrawable, rectangle));
        CompositeMode compositeMode = graphics.getCompositeMode();
        graphics.setTransform(null);
        graphics.setCompositeMode(CompositeMode.SRC);
        PrEffectHelper.render(blend, graphics, 0.0f, 0.0f, null);
        graphics.setCompositeMode(compositeMode);
        Effect.releaseCompatibleImage(filterContext, prDrawable);
        ((ReadbackGraphics)graphics).releaseReadBackBuffer(rTTexture);
    }

    private void renderRectClip(Graphics graphics, NGRectangle nGRectangle) {
        BaseBounds baseBounds = nGRectangle.getShape().getBounds();
        if (!nGRectangle.getTransform().isIdentity()) {
            baseBounds = nGRectangle.getTransform().transform(baseBounds, baseBounds);
        }
        BaseTransform baseTransform = graphics.getTransformNoClone();
        Rectangle rectangle = graphics.getClipRectNoClone();
        baseBounds = baseTransform.transform(baseBounds, baseBounds);
        baseBounds.intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        if (baseBounds.isEmpty() || baseBounds.getWidth() == 0.0f || baseBounds.getHeight() == 0.0f) {
            return;
        }
        graphics.setClipRect(new Rectangle(baseBounds));
        if (this.getOpacity() < 1.0f) {
            this.renderOpacity(graphics);
        } else if (this.getCacheFilter() != null) {
            this.renderCached(graphics);
        } else if (this.getEffectFilter() != null) {
            this.renderEffect(graphics);
        } else {
            this.renderContent(graphics);
        }
        graphics.setClipRect(rectangle);
        nGRectangle.clearDirty();
    }

    private void renderClip(Graphics graphics) {
        Object object;
        if ((double)this.getClipNode().getOpacity() == 0.0) {
            this.clearDirtyTree();
            return;
        }
        BaseTransform baseTransform = graphics.getTransformNoClone();
        BaseBounds baseBounds = this.getClippedBounds(new RectBounds(), baseTransform);
        if (baseBounds.isEmpty()) {
            this.clearDirtyTree();
            return;
        }
        if (this.getClipNode() instanceof NGRectangle && ((NGRectangle)(object = (NGRectangle)this.getClipNode())).isRectClip(baseTransform)) {
            this.renderRectClip(graphics, (NGRectangle)object);
            return;
        }
        if (!NGNode.isOffscreenRenderingSupported(graphics)) {
            if (this.getOpacity() < 1.0f) {
                this.renderOpacity(graphics);
            } else {
                this.renderContent(graphics);
            }
            return;
        }
        object = new Rectangle(baseBounds);
        ((Rectangle)object).intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        FilterContext filterContext = NGNode.getFilterContext(graphics);
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, ((Rectangle)object).width, ((Rectangle)object).height);
        if (prDrawable == null) {
            this.clearDirtyTree();
            return;
        }
        Graphics graphics2 = prDrawable.createGraphics();
        graphics2.setHasPreCullingBits(graphics.hasPreCullingBits());
        graphics2.setClipRectIndex(graphics.getClipRectIndex());
        graphics2.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        graphics2.transform(baseTransform);
        if (this.getOpacity() < 1.0f) {
            this.renderOpacity(graphics2);
        } else if (this.getCacheFilter() != null) {
            this.renderCached(graphics2);
        } else if (this.getEffectFilter() != null) {
            this.renderEffect(graphics2);
        } else {
            this.renderContent(graphics2);
        }
        PrDrawable prDrawable2 = (PrDrawable)Effect.getCompatibleImage(filterContext, ((Rectangle)object).width, ((Rectangle)object).height);
        if (prDrawable2 == null) {
            this.getClipNode().clearDirtyTree();
            Effect.releaseCompatibleImage(filterContext, prDrawable);
            return;
        }
        Graphics graphics3 = prDrawable2.createGraphics();
        graphics3.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        graphics3.transform(baseTransform);
        this.getClipNode().render(graphics3, null, null);
        graphics.setTransform(null);
        Blend blend = new Blend(Blend.Mode.SRC_IN, new PassThrough(prDrawable2, (Rectangle)object), new PassThrough(prDrawable, (Rectangle)object));
        PrEffectHelper.render(blend, graphics, 0.0f, 0.0f, null);
        Effect.releaseCompatibleImage(filterContext, prDrawable);
        Effect.releaseCompatibleImage(filterContext, prDrawable2);
    }

    private void renderOpacity(Graphics graphics) {
        if (this.getEffectFilter() != null || this.getCacheFilter() != null || !this.hasOverlappingContents() || !NGNode.isOffscreenRenderingSupported(graphics)) {
            float f = graphics.getExtraAlpha();
            graphics.setExtraAlpha(f * this.getOpacity());
            if (this.getCacheFilter() != null) {
                this.renderCached(graphics);
            } else if (this.getEffectFilter() != null) {
                this.renderEffect(graphics);
            } else {
                this.renderContent(graphics);
            }
            graphics.setExtraAlpha(f);
            return;
        }
        FilterContext filterContext = NGNode.getFilterContext(graphics);
        BaseTransform baseTransform = graphics.getTransformNoClone();
        BaseBounds baseBounds = this.getContentBounds(new RectBounds(), baseTransform);
        Rectangle rectangle = new Rectangle(baseBounds);
        rectangle.intersectWith(PrEffectHelper.getGraphicsClipNoClone(graphics));
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle.width, rectangle.height);
        if (prDrawable == null) {
            return;
        }
        Graphics graphics2 = prDrawable.createGraphics();
        graphics2.setHasPreCullingBits(graphics.hasPreCullingBits());
        graphics2.setClipRectIndex(graphics.getClipRectIndex());
        graphics2.translate(-rectangle.x, -rectangle.y);
        graphics2.transform(baseTransform);
        this.renderContent(graphics2);
        graphics.setTransform(null);
        float f = graphics.getExtraAlpha();
        graphics.setExtraAlpha(this.getOpacity() * f);
        graphics.drawTexture(prDrawable.getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setExtraAlpha(f);
        Effect.releaseCompatibleImage(filterContext, prDrawable);
    }

    private void renderCached(Graphics graphics) {
        if (this.isContentBounds2D() && graphics.getTransformNoClone().is2D()) {
            ((CacheFilter)this.getCacheFilter()).render(graphics);
        } else {
            this.renderContent(graphics);
        }
    }

    protected void renderEffect(Graphics graphics) {
        ((EffectFilter)this.getEffectFilter()).render(graphics);
    }

    protected abstract void renderContent(Graphics var1);

    protected abstract boolean hasOverlappingContents();

    protected boolean cull(Rectangle rectangle, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (rectangle == null) {
            return false;
        }
        if (this.transformedBounds.isEmpty()) {
            return true;
        }
        if (baseTransform.isIdentity()) {
            TEMP_BOUNDS.deriveWithNewBounds(this.transformedBounds);
        } else {
            baseTransform.transform(this.transformedBounds, TEMP_BOUNDS);
        }
        if (generalTransform3D != null && !generalTransform3D.isIdentity()) {
            generalTransform3D.transform(TEMP_BOUNDS, TEMP_BOUNDS);
        }
        TEMP_BOUNDS.deriveWithNewBounds(TEMP_BOUNDS.getMinX(), TEMP_BOUNDS.getMinY(), 0.0f, TEMP_BOUNDS.getMaxX(), TEMP_BOUNDS.getMaxY(), 0.0f);
        return TEMP_BOUNDS.disjoint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static RectBounds accumulate(RectBounds rectBounds, RectBounds rectBounds2) {
        return NGNode.accumulate(rectBounds, rectBounds2, false);
    }

    static RectBounds accumulate(RectBounds rectBounds, RectBounds rectBounds2, boolean bl) {
        if (rectBounds2 != null && rectBounds2.getWidth() > 0.0f && rectBounds2.getHeight() > 0.0f) {
            if (rectBounds == null) {
                rectBounds = bl ? rectBounds2 : new RectBounds(rectBounds2);
            } else {
                rectBounds.unionWith(rectBounds2);
            }
        }
        return rectBounds;
    }

    static boolean isOffscreenRenderingSupported(Graphics graphics) {
        if (offscreenSupported == null) {
            offscreenSupported = graphics.getResourceFactory().isOffscreenRenderingSupported();
        }
        return offscreenSupported;
    }

    boolean isReadbackSupported(Graphics graphics) {
        return NGNode.isOffscreenRenderingSupported(graphics) && graphics instanceof ReadbackGraphics && ((ReadbackGraphics)graphics).canReadBack();
    }

    @Override
    protected BaseCacheFilter createCacheFilter(BaseNode baseNode, PGNode.CacheHint cacheHint) {
        return new CacheFilter(baseNode, cacheHint);
    }

    @Override
    protected BaseEffectFilter createEffectFilter(Effect effect) {
        return new EffectFilter(effect, this);
    }

    static FilterContext getFilterContext(Graphics graphics) {
        return PrFilterContext.getInstance(graphics.getAssociatedScreen());
    }

    static {
        pipeline = GraphicsPipeline.getPipeline();
        effectsSupported = pipeline == null ? false : pipeline.isEffectSupported();
    }

    private static class PassThrough
    extends Effect {
        private PrDrawable img;
        private Rectangle bounds;

        PassThrough(PrDrawable prDrawable, Rectangle rectangle) {
            this.img = prDrawable;
            this.bounds = rectangle;
        }

        @Override
        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            return new ImageData(filterContext, this.img, new Rectangle(this.bounds));
        }

        @Override
        public RectBounds getBounds(BaseTransform baseTransform, Effect effect) {
            return new RectBounds(this.bounds);
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext filterContext) {
            return Effect.AccelType.INTRINSIC;
        }
    }

    protected static class EffectFilter
    extends BaseEffectFilter {
        EffectFilter(Effect effect, NGNode nGNode) {
            super(effect, nGNode);
        }

        void render(Graphics graphics) {
            NodeEffectInput nodeEffectInput = (NodeEffectInput)this.getNodeInput();
            if (!NGNode.isOffscreenRenderingSupported(graphics)) {
                ((NGNode)nodeEffectInput.getNode()).renderContent(graphics);
                return;
            }
            PrEffectHelper.render(this.getEffect(), graphics, 0.0f, 0.0f, nodeEffectInput);
            nodeEffectInput.flush();
        }

        @Override
        protected BaseNodeEffectInput createNodeEffectInput(BaseNode baseNode) {
            return new NodeEffectInput((NGNode)baseNode);
        }
    }

    private static class CacheFilter
    extends BaseCacheFilter {
        private final RectBounds TEMP_BOUNDS = new RectBounds();
        private final Rectangle TEMP_RECT = new Rectangle();

        CacheFilter(BaseNode baseNode, PGNode.CacheHint cacheHint) {
            super(baseNode, cacheHint);
        }

        void render(Graphics graphics) {
            if (!NGNode.isOffscreenRenderingSupported(graphics)) {
                ((NGNode)this.node).renderContent(graphics);
                return;
            }
            BaseTransform baseTransform = graphics.getTransformNoClone();
            FilterContext filterContext = NGNode.getFilterContext(graphics);
            super.render(graphics, baseTransform, filterContext);
        }

        @Override
        protected ImageData impl_createImageData(FilterContext filterContext, BaseTransform baseTransform) {
            PrDrawable prDrawable;
            BaseBounds baseBounds = ((NGNode)this.node).getEffectBounds(this.TEMP_BOUNDS, baseTransform);
            this.TEMP_RECT.setBounds(baseBounds);
            try {
                prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, this.TEMP_RECT.width, this.TEMP_RECT.height);
            }
            catch (Throwable throwable) {
                prDrawable = null;
            }
            if (prDrawable != null) {
                Graphics graphics = prDrawable.createGraphics();
                graphics.translate(-this.TEMP_RECT.x, -this.TEMP_RECT.y);
                if (baseTransform != null) {
                    graphics.transform(baseTransform);
                }
                if (((NGNode)this.node).getEffectFilter() != null) {
                    ((NGNode)this.node).renderEffect(graphics);
                } else {
                    ((NGNode)this.node).renderContent(graphics);
                }
            }
            return new ImageData(filterContext, prDrawable, this.TEMP_RECT);
        }

        @Override
        protected void impl_renderNodeToScreen(Object object, BaseTransform baseTransform) {
            Graphics graphics = (Graphics)object;
            NGNode nGNode = (NGNode)this.node;
            if (nGNode.getEffectFilter() != null) {
                nGNode.renderEffect(graphics);
            } else {
                nGNode.renderContent(graphics);
            }
        }

        @Override
        protected void impl_renderCacheToScreen(Object object, Filterable filterable, double d, double d2) {
            Graphics graphics = (Graphics)object;
            graphics.setTransform(this.screenXform.getMxx(), this.screenXform.getMyx(), this.screenXform.getMxy(), this.screenXform.getMyy(), d, d2);
            graphics.translate((float)this.cachedX, (float)this.cachedY);
            Texture texture = ((PrDrawable)filterable).getTextureObject();
            Rectangle rectangle = this.cachedImageData.getUntransformedBounds();
            graphics.drawTexture(texture, 0.0f, 0.0f, rectangle.width, rectangle.height);
        }
    }
}

