/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.BaseNode;
import com.sun.javafx.sg.DirtyRegionContainer;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NodeEffectInput;
import com.sun.prism.Graphics;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NGGroup
extends NGNode
implements PGGroup {
    private Blend.Mode blendMode = Blend.Mode.SRC_OVER;
    private List<PGNode> children = new ArrayList<PGNode>(1);
    private List<PGNode> unmod = Collections.unmodifiableList(this.children);
    private List<PGNode> removed;
    private static final int REGION_CONTAINES_MASK = 0x2AAAAAAA;
    private final RectBounds TEMP_CULLING_BOUNDS = new RectBounds();

    @Override
    public List<PGNode> getChildren() {
        return this.unmod;
    }

    @Override
    public void add(int n, PGNode pGNode) {
        if (n < -1 || n > this.children.size()) {
            throw new IndexOutOfBoundsException("invalid index");
        }
        BaseNode baseNode = (BaseNode)pGNode;
        BaseNode baseNode2 = baseNode.getParent();
        baseNode.setParent(this);
        this.childDirty = true;
        if (n == -1) {
            this.children.add(pGNode);
        } else {
            this.children.add(n, pGNode);
        }
        baseNode.markDirty();
        this.markTreeDirtyNoIncrement();
        this.geometryChanged();
    }

    @Override
    public void clearFrom(int n) {
        if (n < this.children.size()) {
            this.children.subList(n, this.children.size()).clear();
            this.geometryChanged();
            this.childDirty = true;
            this.markTreeDirtyNoIncrement();
        }
    }

    @Override
    public List<PGNode> getRemovedChildren() {
        return this.removed;
    }

    @Override
    public void addToRemoved(PGNode pGNode) {
        if (this.removed == null) {
            this.removed = new ArrayList<PGNode>();
        }
        if (this.dirtyChildrenAccumulated > 12) {
            return;
        }
        this.removed.add(pGNode);
        ++this.dirtyChildrenAccumulated;
        if (this.dirtyChildrenAccumulated > 12) {
            this.removed.clear();
        }
    }

    @Override
    protected void clearDirty() {
        super.clearDirty();
        if (this.removed != null) {
            this.removed.clear();
        }
    }

    @Override
    public void remove(PGNode pGNode) {
        this.children.remove(pGNode);
        this.geometryChanged();
        this.childDirty = true;
        this.markTreeDirtyNoIncrement();
    }

    @Override
    public void remove(int n) {
        this.children.remove(n);
        this.geometryChanged();
        this.childDirty = true;
        this.markTreeDirtyNoIncrement();
    }

    @Override
    public void clear() {
        this.children.clear();
        this.childDirty = false;
        this.geometryChanged();
        this.markTreeDirtyNoIncrement();
    }

    @Override
    public void setBlendMode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Mode must be non-null");
        }
        if (this.blendMode != object) {
            this.blendMode = (Blend.Mode)((Object)object);
            this.visualsChanged();
        }
    }

    @Override
    protected void renderContent(Graphics graphics) {
        if (this.children == null) {
            return;
        }
        if (this.blendMode == Blend.Mode.SRC_OVER || this.children.size() < 2 || !NGGroup.isOffscreenRenderingSupported(graphics)) {
            for (int i = 0; i < this.children.size(); ++i) {
                NGNode nGNode;
                try {
                    nGNode = (NGNode)this.children.get(i);
                }
                catch (Exception exception) {
                    nGNode = null;
                }
                if (nGNode == null) continue;
                nGNode.render(graphics, null, null);
            }
            return;
        }
        Blend blend = new Blend(this.blendMode, null, null);
        FilterContext filterContext = NGGroup.getFilterContext(graphics);
        ImageData imageData = null;
        boolean bl = true;
        do {
            Object object;
            BaseTransform baseTransform = graphics.getTransformNoClone().copy();
            if (imageData != null) {
                imageData.unref();
                imageData = null;
            }
            Rectangle rectangle = PrEffectHelper.getGraphicsClipNoClone(graphics);
            for (int i = 0; i < this.children.size(); ++i) {
                object = (NGNode)this.children.get(i);
                ImageData imageData2 = NodeEffectInput.getImageDataForNode(filterContext, (NGNode)object, false, baseTransform, rectangle);
                if (imageData == null) {
                    imageData = imageData2;
                    continue;
                }
                ImageData imageData3 = blend.filterImageDatas(filterContext, baseTransform, rectangle, new ImageData[]{imageData, imageData2});
                imageData.unref();
                imageData2.unref();
                imageData = imageData3;
            }
            if (imageData == null || !(bl = imageData.validate(filterContext))) continue;
            Rectangle rectangle2 = imageData.getUntransformedBounds();
            object = (PrDrawable)imageData.getUntransformedImage();
            graphics.setTransform(imageData.getTransform());
            graphics.drawTexture(((PrTexture)object).getTextureObject(), rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } while (imageData == null || !bl);
        if (imageData != null) {
            imageData.unref();
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        int n;
        if (this.blendMode != Blend.Mode.SRC_OVER) {
            return false;
        }
        int n2 = n = this.children == null ? 0 : this.children.size();
        if (n == 1) {
            return ((NGNode)this.children.get(0)).hasOverlappingContents();
        }
        return n != 0;
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    @Override
    protected boolean hasVisuals() {
        return false;
    }

    @Override
    protected boolean needsBlending() {
        Blend.Mode mode = this.getNodeBlendMode();
        return mode != null;
    }

    @Override
    protected void markCullRegions(DirtyRegionContainer dirtyRegionContainer, int n, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        super.markCullRegions(dirtyRegionContainer, n, baseTransform, generalTransform3D);
        if (this.cullingBits == -1 || this.cullingBits != 0 && (this.cullingBits & 0x2AAAAAAA) == 0) {
            double d = baseTransform.getMxx();
            double d2 = baseTransform.getMxy();
            double d3 = baseTransform.getMxz();
            double d4 = baseTransform.getMxt();
            double d5 = baseTransform.getMyx();
            double d6 = baseTransform.getMyy();
            double d7 = baseTransform.getMyz();
            double d8 = baseTransform.getMyt();
            double d9 = baseTransform.getMzx();
            double d10 = baseTransform.getMzy();
            double d11 = baseTransform.getMzz();
            double d12 = baseTransform.getMzt();
            BaseTransform baseTransform2 = baseTransform.deriveWithConcatenation(this.getTransform());
            for (int i = 0; i < this.children.size(); ++i) {
                NGNode nGNode = (NGNode)this.children.get(i);
                nGNode.markCullRegions(dirtyRegionContainer, this.cullingBits, baseTransform2, generalTransform3D);
            }
            baseTransform.restoreTransform(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        }
    }

    @Override
    public void drawCullBits(Graphics graphics) {
        if (this.getParent() != null) {
            super.drawCullBits(graphics);
        }
        if (this.cullingBits != 0) {
            BaseTransform baseTransform = graphics.getTransformNoClone();
            double d = baseTransform.getMxx();
            double d2 = baseTransform.getMxy();
            double d3 = baseTransform.getMxz();
            double d4 = baseTransform.getMxt();
            double d5 = baseTransform.getMyx();
            double d6 = baseTransform.getMyy();
            double d7 = baseTransform.getMyz();
            double d8 = baseTransform.getMyt();
            double d9 = baseTransform.getMzx();
            double d10 = baseTransform.getMzy();
            double d11 = baseTransform.getMzz();
            double d12 = baseTransform.getMzt();
            graphics.transform(this.getTransform());
            for (int i = 0; i < this.children.size(); ++i) {
                NGNode nGNode = (NGNode)this.children.get(i);
                nGNode.drawCullBits(graphics);
            }
            graphics.setTransform3D(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        }
    }
}

