/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Value;
import com.sun.javafx.scene.layout.region.BackgroundImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.image.Image;

public final class BackgroundImageConverter
extends StyleConverter<Value[], List<BackgroundImage>> {
    public static BackgroundImageConverter getInstance() {
        return Holder.BACKGROUND_IMAGE_CONVERTER;
    }

    private BackgroundImageConverter() {
    }

    @Override
    public List<BackgroundImage> convert(Map<StyleableProperty, Object> map) {
        String[] stringArray = null;
        BackgroundImage.BackgroundRepeat[] backgroundRepeatArray = null;
        BackgroundImage.BackgroundPosition[] backgroundPositionArray = null;
        BackgroundImage.BackgroundSize[] backgroundSizeArray = null;
        List<StyleableProperty> list = BackgroundImage.impl_CSS_STYLEABLES();
        for (int i = 0; i < list.size(); ++i) {
            StyleableProperty styleableProperty = list.get(i);
            Object object = map.get(styleableProperty);
            if (object == null) continue;
            if ("-fx-background-image".equals(styleableProperty.getProperty())) {
                stringArray = (String[])object;
                continue;
            }
            if ("-fx-background-repeat".equals(styleableProperty.getProperty())) {
                backgroundRepeatArray = (BackgroundImage.BackgroundRepeat[])object;
                continue;
            }
            if ("-fx-background-position".equals(styleableProperty.getProperty())) {
                backgroundPositionArray = (BackgroundImage.BackgroundPosition[])object;
                continue;
            }
            if (!"-fx-background-size".equals(styleableProperty.getProperty())) continue;
            backgroundSizeArray = (BackgroundImage.BackgroundSize[])object;
        }
        ArrayList<BackgroundImage> arrayList = new ArrayList<BackgroundImage>();
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            BackgroundImage.BackgroundRepeat backgroundRepeat = backgroundRepeatArray != null ? backgroundRepeatArray[Math.min(i, backgroundRepeatArray.length - 1)] : null;
            BackgroundImage.BackgroundPosition backgroundPosition = backgroundPositionArray != null ? backgroundPositionArray[Math.min(i, backgroundPositionArray.length - 1)] : null;
            BackgroundImage.BackgroundSize backgroundSize = backgroundSizeArray != null ? backgroundSizeArray[Math.min(i, backgroundSizeArray.length - 1)] : null;
            BackgroundImage.Builder builder = new BackgroundImage.Builder();
            builder.setImage(new Image(stringArray[i]));
            if (backgroundRepeat != null) {
                builder.setRepeatX(backgroundRepeat.getRepeatX()).setRepeatY(backgroundRepeat.getRepeatY());
            }
            if (backgroundPosition != null) {
                builder.setTop(backgroundPosition.getTop()).setRight(backgroundPosition.getRight()).setBottom(backgroundPosition.getBottom()).setLeft(backgroundPosition.getLeft()).setProportionalHPos(backgroundPosition.isProportionalHPos()).setProportionalVPos(backgroundPosition.isProportionalVPos());
            }
            if (backgroundSize != null) {
                builder.setWidth(backgroundSize.getWidth()).setHeight(backgroundSize.getHeight()).setContain(backgroundSize.isContain()).setCover(backgroundSize.isCover()).setProportionalWidth(backgroundSize.isProportionalWidth()).setProportionalHeight(backgroundSize.isProportionalHeight());
            }
            arrayList.add(builder.build());
        }
        return arrayList;
    }

    private static class Holder {
        private static final BackgroundImageConverter BACKGROUND_IMAGE_CONVERTER = new BackgroundImageConverter();

        private Holder() {
        }
    }
}

