/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;

public class TableRowSkin<T>
extends CellSkinBase<TableRow<T>, CellBehaviorBase<TableRow<T>>> {
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    private WeakHashMap<TableColumn, TableCell> cellsMap;
    private final List<TableCell> cells = new ArrayList<TableCell>();
    private int fullRefreshCounter = 100;
    private boolean showColumns = true;
    private boolean isDirty = false;
    private boolean updateCells = false;
    private ListChangeListener visibleLeafColumnsListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            TableRowSkin.this.isDirty = true;
            TableRowSkin.this.requestLayout();
        }
    };

    public TableRowSkin(TableRow<T> tableRow) {
        super(tableRow, new CellBehaviorBase<TableRow<T>>(tableRow));
        this.recreateCells();
        this.updateCells(true);
        this.initBindings();
        this.registerChangeListener(tableRow.editingProperty(), "EDITING");
        this.registerChangeListener(tableRow.indexProperty(), "ROW");
        this.registerChangeListener(tableRow.tableViewProperty(), "TABLE_VIEW");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        if (string == "TEXT" || string == "GRAPHIC" || string == "EDITING") {
            this.updateShowColumns();
        }
        super.handleControlPropertyChanged(string);
        if (string == "ROW") {
            this.updateCells = true;
            this.requestLayout();
        } else if (string == "TABLE_VIEW") {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                ((TableCell)this.getChildren().get(i)).updateTableView(((TableRow)this.getSkinnable()).getTableView());
            }
        }
    }

    private void updateShowColumns() {
        boolean bl;
        boolean bl2 = bl = this.isIgnoreText() && this.isIgnoreGraphic();
        if (this.showColumns == bl) {
            return;
        }
        this.showColumns = bl;
        this.requestLayout();
    }

    private void initBindings() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("TableRowSkin does not have a Skinnable set to a TableRow instance");
        }
        if (((TableRow)this.getSkinnable()).getTableView() == null) {
            throw new IllegalStateException("TableRow not have the TableView property set");
        }
        ((TableRow)this.getSkinnable()).getTableView().getVisibleLeafColumns().addListener(new WeakListChangeListener(this.visibleLeafColumnsListener));
    }

    private void doUpdateCheck() {
        if (this.isDirty) {
            this.recreateCells();
            this.updateCells(true);
            this.isDirty = false;
        } else if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    @Override
    protected void layoutChildren() {
        this.doUpdateCheck();
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView == null) {
            return;
        }
        if (this.cellsMap.isEmpty()) {
            return;
        }
        if (this.showColumns && !tableView.getVisibleLeafColumns().isEmpty()) {
            double d = this.getInsets().getLeft();
            ObservableList observableList = tableView.getVisibleLeafColumns();
            double d2 = this.getInsets().getTop() + this.getInsets().getBottom();
            double d3 = this.getInsets().getLeft() + this.getInsets().getRight();
            for (int i = 0; i < observableList.size(); ++i) {
                TableColumn tableColumn = (TableColumn)observableList.get(i);
                TableCell tableCell = this.cellsMap.get(tableColumn);
                if (tableCell == null) continue;
                double d4 = this.snapSize(tableCell.prefWidth(-1.0) - d3);
                double d5 = Math.max(this.getHeight(), tableCell.prefHeight(-1.0));
                d5 = this.snapSize(d5 - d2);
                tableCell.resize(d4, d5);
                tableCell.relocate(d, this.getInsets().getTop());
                d += d4;
            }
        } else {
            super.layoutChildren();
        }
    }

    private void recreateCells() {
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView == null) {
            this.clearCellsMap();
            return;
        }
        ObservableList observableList = tableView.getVisibleLeafColumns();
        if (this.fullRefreshCounter == 0 || this.cellsMap == null) {
            this.clearCellsMap();
            this.cellsMap = new WeakHashMap(observableList.size());
            this.fullRefreshCounter = 100;
        }
        --this.fullRefreshCounter;
        for (TableColumn tableColumn : observableList) {
            if (this.cellsMap.containsKey(tableColumn)) continue;
            TableCell tableCell = tableColumn.getCellFactory().call(tableColumn);
            tableCell.updateTableColumn(tableColumn);
            tableCell.updateTableView(tableView);
            this.cellsMap.put(tableColumn, tableCell);
        }
    }

    private void clearCellsMap() {
        if (this.cellsMap != null) {
            this.cellsMap.clear();
        }
    }

    private void updateCells(boolean bl) {
        this.cells.clear();
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView != null) {
            for (TableColumn tableColumn : tableView.getVisibleLeafColumns()) {
                TableCell tableCell = this.cellsMap.get(tableColumn);
                if (tableCell == null) continue;
                tableCell.updateIndex(((TableRow)this.getSkinnable()).getIndex());
                tableCell.updateTableRow((TableRow)this.getSkinnable());
                this.cells.add(tableCell);
            }
        }
        if (bl) {
            if (this.showColumns) {
                if (this.cells.isEmpty()) {
                    this.getChildren().clear();
                } else {
                    this.getChildren().setAll((Collection<Node>)this.cells);
                }
            } else {
                this.getChildren().clear();
                if (!this.isIgnoreText() || !this.isIgnoreGraphic()) {
                    this.getChildren().add((Node)((Object)this.getSkinnable()));
                }
            }
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        this.doUpdateCheck();
        if (this.showColumns) {
            double d2 = 0.0;
            if (((TableRow)this.getSkinnable()).getTableView() != null) {
                for (TableColumn tableColumn : ((TableRow)this.getSkinnable()).getTableView().getVisibleLeafColumns()) {
                    d2 += tableColumn.getWidth();
                }
            }
            return d2;
        }
        return super.computePrefWidth(d);
    }

    @Override
    protected double computePrefHeight(double d) {
        this.doUpdateCheck();
        if (this.showColumns) {
            double d2 = 0.0;
            int n = this.cells.size();
            for (int i = 0; i < n; ++i) {
                TableCell tableCell = this.cells.get(i);
                d2 = Math.max(d2, tableCell.prefHeight(-1.0));
            }
            return Math.max(d2, Math.max(this.getCellSize(), this.minHeight(-1.0)));
        }
        return super.computePrefHeight(d);
    }
}

