/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;

public final class LadderConverter
extends StyleConverter<Value[], Color> {
    public static LadderConverter getInstance() {
        return Holder.INSTANCE;
    }

    private LadderConverter() {
    }

    @Override
    public Color convert(Value<Value[], Color> value, Font font) {
        Value[] valueArray = value.getValue();
        Color color = (Color)valueArray[0].convert(font);
        Stop[] stopArray = new Stop[valueArray.length - 1];
        for (int i = 1; i < valueArray.length; ++i) {
            stopArray[i - 1] = (Stop)valueArray[i].convert(font);
        }
        return Utils.ladder(color, stopArray);
    }

    public String toString() {
        return "LadderConverter";
    }

    private static class Holder {
        static LadderConverter INSTANCE = new LadderConverter();

        private Holder() {
        }
    }
}

