/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class EffectConverter
extends StyleConverter<Value[], Effect> {
    public static EffectConverter getInstance() {
        return Holder.EFFECT_CONVERTER;
    }

    protected EffectConverter() {
    }

    public String toString() {
        return "EffectConverter";
    }

    public static final class InnerShadowConverter
    extends EffectConverter {
        public static InnerShadowConverter getInstance() {
            return Holder.INNER_SHADOW_INSTANCE;
        }

        private InnerShadowConverter() {
        }

        @Override
        public Effect convert(Value<Value[], Effect> value, Font font) {
            Value[] valueArray = value.getValue();
            BlurType blurType = (BlurType)((Object)valueArray[0].convert(font));
            Color color = (Color)valueArray[1].convert(font);
            Double d = ((Size)valueArray[2].convert(font)).pixels(font);
            Double d2 = ((Size)valueArray[3].convert(font)).pixels(font);
            Double d3 = ((Size)valueArray[4].convert(font)).pixels(font);
            Double d4 = ((Size)valueArray[5].convert(font)).pixels(font);
            InnerShadow innerShadow = new InnerShadow();
            if (blurType != null) {
                innerShadow.setBlurType(blurType);
            }
            if (color != null) {
                innerShadow.setColor(color);
            }
            if (d != null) {
                innerShadow.setRadius(d);
            }
            if (d2 != null) {
                innerShadow.setChoke(d2);
            }
            if (d3 != null) {
                innerShadow.setOffsetX(d3);
            }
            if (d4 != null) {
                innerShadow.setOffsetY(d4);
            }
            return innerShadow;
        }

        @Override
        public String toString() {
            return "InnerShadowConverter";
        }
    }

    public static final class DropShadowConverter
    extends EffectConverter {
        public static DropShadowConverter getInstance() {
            return Holder.DROP_SHADOW_INSTANCE;
        }

        private DropShadowConverter() {
        }

        @Override
        public Effect convert(Value<Value[], Effect> value, Font font) {
            Value[] valueArray = value.getValue();
            BlurType blurType = (BlurType)((Object)valueArray[0].convert(font));
            Color color = (Color)valueArray[1].convert(font);
            Double d = ((Size)valueArray[2].convert(font)).pixels(font);
            Double d2 = ((Size)valueArray[3].convert(font)).pixels(font);
            Double d3 = ((Size)valueArray[4].convert(font)).pixels(font);
            Double d4 = ((Size)valueArray[5].convert(font)).pixels(font);
            DropShadow dropShadow = new DropShadow();
            if (blurType != null) {
                dropShadow.setBlurType(blurType);
            }
            if (color != null) {
                dropShadow.setColor(color);
            }
            if (d2 != null) {
                dropShadow.setSpread(d2);
            }
            if (d != null) {
                dropShadow.setRadius(d);
            }
            if (d3 != null) {
                dropShadow.setOffsetX(d3);
            }
            if (d4 != null) {
                dropShadow.setOffsetY(d4);
            }
            return dropShadow;
        }

        @Override
        public String toString() {
            return "DropShadowConverter";
        }
    }

    private static class Holder {
        static EffectConverter EFFECT_CONVERTER = new EffectConverter();
        static DropShadowConverter DROP_SHADOW_INSTANCE = new DropShadowConverter();
        static InnerShadowConverter INNER_SHADOW_INSTANCE = new InnerShadowConverter();

        private Holder() {
        }
    }
}

