/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.Value;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.css.parser.CSSParser;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.text.Font;

public class StyleableProperty {
    private static Map<Class, List<StyleableProperty>> styleablesCache = null;
    public static final StyleableProperty FONT = new StyleableProperty();
    private final Class owningClass;
    private final String fieldName;
    private String property = null;
    private StyleConverter converter = null;
    private Value initialValue = null;
    private List<StyleableProperty> subProperties = null;
    private boolean fieldIsStyleable = true;
    private Field field = null;
    private Styleable styleable = null;
    private Boolean inherits = null;
    private final int index;
    private static int maxIndex;

    public static List<StyleableProperty> getStyleables(Node node) {
        return StyleableProperty.getStyleables(node.getClass());
    }

    private static Method getMethod_impl_CSS_STYLEABLES(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod("impl_CSS_STYLEABLES", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
    }

    public static List<StyleableProperty> getStyleables(Class clazz) {
        ArrayList<StyleableProperty> arrayList;
        if (styleablesCache != null && (arrayList = styleablesCache.get(clazz)) != null) {
            return arrayList;
        }
        arrayList = new ArrayList();
        Class clazz2 = clazz;
        do {
            Field[] fieldArray;
            Method method;
            if ((method = StyleableProperty.getMethod_impl_CSS_STYLEABLES(clazz2)) != null) {
                try {
                    arrayList.addAll((List)method.invoke(null, new Object[0]));
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println(illegalAccessException.toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(invocationTargetException.toString());
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    System.err.println(exceptionInInitializerError.toString());
                }
            }
            final Class clazz3 = clazz2;
            for (Field field : fieldArray = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    return clazz3.getDeclaredFields();
                }
            })) {
                if (!field.isAnnotationPresent(Styleable.class)) continue;
                Styleable styleable = field.getAnnotation(Styleable.class);
                StyleableProperty styleableProperty = new StyleableProperty(clazz2, field.getName());
                arrayList.add(styleableProperty);
                styleableProperty.styleable = styleable;
                styleableProperty.field = field;
                styleableProperty.property = styleable.property();
                styleableProperty.inherits = styleable.inherits();
            }
        } while (!Node.class.equals((Object)clazz2) && (clazz2 = clazz2.getSuperclass()) != null);
        if (styleablesCache == null) {
            styleablesCache = new HashMap<Class, List<StyleableProperty>>();
        }
        styleablesCache.put(clazz, arrayList);
        return arrayList;
    }

    public static StyleableProperty createArtificialStyleable(String string, StyleConverter styleConverter, String string2) {
        assert (string != null && !string.trim().isEmpty());
        StyleableProperty styleableProperty = new StyleableProperty();
        styleableProperty.property = string;
        styleableProperty.converter = styleConverter;
        styleableProperty.initialValue = string2 != null && !string2.isEmpty() ? styleableProperty.parse(string, string2) : null;
        return styleableProperty;
    }

    public static List createFontSubProperties(String string) {
        StyleableProperty styleableProperty = new StyleableProperty();
        styleableProperty.property = string.concat("-family");
        styleableProperty.converter = StringConverter.getInstance();
        styleableProperty.inherits = true;
        StyleableProperty styleableProperty2 = new StyleableProperty();
        styleableProperty2.property = string.concat("-size");
        styleableProperty2.converter = SizeConverter.getInstance();
        styleableProperty2.inherits = true;
        StyleableProperty styleableProperty3 = new StyleableProperty();
        styleableProperty3.property = string.concat("-weight");
        styleableProperty3.converter = FontConverter.WeightConverter.getInstance();
        styleableProperty3.inherits = true;
        StyleableProperty styleableProperty4 = new StyleableProperty();
        styleableProperty4.property = string.concat("-style");
        styleableProperty4.converter = FontConverter.StyleConverter.getInstance();
        styleableProperty4.inherits = true;
        return Collections.unmodifiableList(Arrays.asList(styleableProperty, styleableProperty2, styleableProperty3, styleableProperty4));
    }

    public Class getOwningClass() {
        return this.owningClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public final String getProperty() {
        Styleable styleable;
        if (this.property == null && (styleable = this.getStyleable()) != null) {
            this.property = styleable.property();
        }
        return this.property;
    }

    public final StyleConverter getConverter() {
        Styleable styleable;
        if (this.converter == null && this.fieldIsStyleable && (styleable = this.getStyleable()) != null) {
            String string = styleable.converter();
            boolean bl = string == null || string.isEmpty();
            this.converter = bl ? this.getInferredConverter() : this.getDeclaredConverter(string);
            if (this.converter == null) {
                if (bl) {
                    this.error("Could not infer 'converter'");
                } else {
                    this.error("Could not create instance of 'converter'", string);
                }
            }
        }
        return this.converter;
    }

    public Value getInitialValue() {
        Styleable styleable;
        if (this.initialValue == null && (styleable = this.getStyleable()) != null && styleable.initial() != null && !styleable.initial().isEmpty()) {
            this.initialValue = this.parse(this.getFieldName(), styleable.initial());
        }
        return this.initialValue;
    }

    public List<StyleableProperty> getSubProperties() {
        return this.subProperties;
    }

    private Field getField() {
        if (this.field == null && this.fieldIsStyleable) {
            this.reflect();
        }
        return this.field;
    }

    private Styleable getStyleable() {
        if (this.styleable == null && this.fieldIsStyleable) {
            Field field = this.getField();
            boolean bl = this.fieldIsStyleable = field != null ? field.isAnnotationPresent(Styleable.class) : false;
            if (this.fieldIsStyleable) {
                this.styleable = field.getAnnotation(Styleable.class);
            } else if (!this.isArtificial()) {
                this.error("Styleable annotation not present");
            }
        }
        return this.styleable;
    }

    public boolean isInherits() {
        if (this.inherits == null) {
            Styleable styleable = this.getStyleable();
            this.inherits = styleable != null ? Boolean.valueOf(styleable.inherits()) : Boolean.FALSE;
        }
        return this.inherits;
    }

    public int getIndex() {
        return this.index;
    }

    public static int getMaxIndex() {
        return maxIndex;
    }

    public StyleableProperty(Class clazz, String string) {
        this(clazz, string, null);
    }

    public StyleableProperty(Class clazz, String string, List<StyleableProperty> list) {
        assert (clazz != null && string != null);
        this.owningClass = clazz;
        this.fieldName = string;
        this.subProperties = list != null ? Collections.unmodifiableList(list) : null;
        this.index = maxIndex++;
    }

    private StyleableProperty() {
        this.owningClass = null;
        this.fieldName = null;
        this.index = -1;
    }

    private boolean isArtificial() {
        return this.owningClass == null || this.fieldName == null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StyleableProperty {");
        if (this.owningClass != null && this.fieldName != null) {
            stringBuilder.append("owningClass: ").append(this.owningClass.getName()).append(", fieldName: ").append(this.fieldName);
            if (this.fieldIsStyleable) {
                if (this.styleable != null) {
                    String string;
                    String string2 = string = this.property != null ? this.property : this.styleable.property();
                    String string3 = this.converter != null ? this.converter.toString() : (this.styleable.converter() != null && !this.styleable.converter().isEmpty() ? this.styleable.converter() : "'not reflected yet'");
                    String string4 = this.initialValue != null ? this.initialValue.toString() : "'" + this.styleable.initial() + "'";
                    String string5 = this.inherits != null ? this.inherits.toString() : Boolean.toString(this.styleable.inherits());
                    stringBuilder.append(", property: ").append(string).append(", converter: ").append(string3).append(", initialValue: ").append(string4).append(", inherits: ").append(string5);
                } else {
                    stringBuilder.append(" 'not reflected yet'");
                }
            } else {
                stringBuilder.append(" 'field is not styleable'");
            }
            stringBuilder.append(", subProperties: ");
            if (this.subProperties != null) {
                stringBuilder.append(this.subProperties.toString());
            } else {
                stringBuilder.append("[]");
            }
        } else {
            stringBuilder.insert(0, "'artificial' ");
            stringBuilder.append("property: ").append(this.property).append(", converter: ").append(this.converter).append(", initialValue: ").append(this.initialValue);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StyleableProperty styleableProperty = (StyleableProperty)object;
        if (!(this.owningClass == styleableProperty.owningClass || this.owningClass != null && this.owningClass.equals(styleableProperty.owningClass))) {
            return false;
        }
        if (this.fieldName == null ? styleableProperty.fieldName != null : !this.fieldName.equals(styleableProperty.fieldName)) {
            return false;
        }
        return this.owningClass != null || this.fieldName != null || !(this.property == null ? styleableProperty.property != null : !this.property.equals(styleableProperty.property));
    }

    public int hashCode() {
        int n = 3;
        n = 73 * n + (this.owningClass != null ? this.owningClass.hashCode() : 0);
        n = 73 * n + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        if (this.owningClass == null && this.fieldName == null) {
            n = 73 * n + (this.property != null ? this.property.hashCode() : 0);
        }
        return n;
    }

    private void reflect() {
        if (this.isArtificial()) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    StyleableProperty.this.field = StyleableProperty.this.getOwningClass().getDeclaredField(StyleableProperty.this.getFieldName());
                    String string = StyleableProperty.this.field.getName();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    System.err.println("No such field '" + StyleableProperty.this.getFieldName() + "' in " + StyleableProperty.this.getOwningClass());
                    StyleableProperty.this.fieldIsStyleable = false;
                }
                return null;
            }
        });
    }

    private StyleConverter getDeclaredConverter(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.error(classNotFoundException.toString());
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.error(exceptionInInitializerError.toString());
        }
        catch (LinkageError linkageError) {
            this.error(linkageError.toString());
        }
        if (clazz == null) {
            return null;
        }
        return this.getConverter(clazz);
    }

    private StyleConverter getConverter(Class clazz) {
        StyleConverter styleConverter = null;
        if (FontConverter.class == clazz) {
            Object object;
            styleConverter = FontConverter.getInstance();
            Value[] valueArray = null;
            String string = this.getStyleable().initial();
            if (!(string == null || string.isEmpty() || "null".equalsIgnoreCase(string) || "inherit".equalsIgnoreCase(string))) {
                object = this.parse("-fx-font", string);
                if (object != null) {
                    this.initialValue = object;
                    valueArray = (Value[])((Value)object).getValue();
                } else {
                    this.error("Error in 'initial'", this.getStyleable().initial());
                    return null;
                }
            }
            object = this.getProperty();
            StyleableProperty styleableProperty = new StyleableProperty();
            styleableProperty.property = (String)object + "-family";
            styleableProperty.converter = StringConverter.getInstance();
            styleableProperty.initialValue = valueArray != null && valueArray.length > 0 ? valueArray[0] : null;
            styleableProperty.inherits = true;
            StyleableProperty styleableProperty2 = new StyleableProperty();
            styleableProperty2.property = (String)object + "-size";
            styleableProperty2.converter = SizeConverter.getInstance();
            styleableProperty2.initialValue = valueArray != null && valueArray.length > 1 ? valueArray[1] : null;
            styleableProperty2.inherits = true;
            StyleableProperty styleableProperty3 = new StyleableProperty();
            styleableProperty3.property = (String)object + "-weight";
            styleableProperty3.converter = FontConverter.WeightConverter.getInstance();
            styleableProperty3.initialValue = valueArray != null && valueArray.length > 2 ? valueArray[2] : null;
            styleableProperty3.inherits = true;
            StyleableProperty styleableProperty4 = new StyleableProperty();
            styleableProperty4.property = (String)object + "-style";
            styleableProperty4.converter = FontConverter.StyleConverter.getInstance();
            styleableProperty4.initialValue = valueArray != null && valueArray.length > 3 ? valueArray[3] : null;
            styleableProperty4.inherits = true;
            this.subProperties = Collections.unmodifiableList(Arrays.asList(styleableProperty, styleableProperty2, styleableProperty3, styleableProperty4));
        } else {
            styleConverter = EnumConverter.class == clazz ? this.getInferredConverter() : StyleConverter.getInstance(clazz);
        }
        return styleConverter;
    }

    private StyleConverter getInferredConverter() {
        StyleConverter styleConverter = null;
        Field field = this.getField();
        if (field == null || field.getType().isArray()) {
            return null;
        }
        Type type = field.getGenericType();
        if (type instanceof Class) {
            Class<?> clazz = field.getType();
            styleConverter = Font.class.isAssignableFrom(clazz) ? this.getConverter(FontConverter.class) : StyleConverter.getInstance(clazz, false);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length != 1) {
                this.error("cannot infer 'converter' from", type.toString());
                return null;
            }
            if (typeArray[0] instanceof Class) {
                Class clazz = (Class)typeArray[0];
                if (Font.class.isAssignableFrom(clazz)) {
                    styleConverter = this.getConverter(FontConverter.class);
                } else {
                    boolean bl = List.class.isAssignableFrom(field.getType());
                    styleConverter = StyleConverter.getInstance(clazz, bl);
                }
            } else {
                this.error("cannot infer 'converter' from", type.toString());
            }
        } else {
            this.error("cannot infer 'converter' from", type.toString());
        }
        return styleConverter;
    }

    private void error(String ... stringArray) {
        this.fieldIsStyleable = false;
        if (Logging.getCSSLogger().isLoggable(800)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.styleable != null) {
                stringBuilder.append("Styleable annotation").append(this.getStyleable().toString());
            }
            if (this.owningClass != null) {
                stringBuilder.append(" for ").append(this.owningClass.getName());
            }
            if (this.fieldName != null) {
                stringBuilder.append(' ').append(this.getFieldName());
            }
            if (stringArray != null && stringArray.length > 0) {
                stringBuilder.append(':');
                for (String string : stringArray) {
                    stringBuilder.append(' ').append(string);
                }
            }
            Logging.getCSSLogger().info(stringBuilder.toString());
        }
    }

    private Value parse(String string, String string2) {
        return CSSParser.getInstance().parseExpr(string, string2);
    }

    static {
        StyleableProperty.FONT.property = "-fx-font";
        StyleableProperty.FONT.converter = FontConverter.getInstance();
        StyleableProperty.FONT.inherits = true;
        StyleableProperty.FONT.subProperties = StyleableProperty.createFontSubProperties("-fx-font");
        maxIndex = 0;
    }
}

