/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.MapInvalidationListenerWrapper;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;

public class UnmodifiableObservableMap<K, V>
extends AbstractMap<K, V>
implements ObservableMap<K, V> {
    private Set<MapChangeListener<? super K, ? super V>> observers;
    private final ObservableMap<K, V> backingMap;

    public UnmodifiableObservableMap(ObservableMap<K, V> observableMap) {
        this.backingMap = observableMap;
        observableMap.addListener(new MapChangeListener<K, V>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
                if (change.getMap() == UnmodifiableObservableMap.this.backingMap) {
                    UnmodifiableObservableMap.this.callObservers(change);
                }
            }
        });
    }

    private void callObservers(MapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.observers != null) {
            for (MapChangeListener<? extends K, ? extends V> mapChangeListener : this.observers) {
                mapChangeListener.onChanged(change);
            }
        }
    }

    private void checkCreateObservers() {
        if (this.observers == null) {
            this.observers = new HashSet<MapChangeListener<? super K, ? super V>>();
        }
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.addListener(new MapInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.removeListener(new MapInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.checkCreateObservers();
        this.observers.add(mapChangeListener);
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.checkCreateObservers();
        this.observers.remove(mapChangeListener);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.backingMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.backingMap.get(object);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.backingMap.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.backingMap.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.backingMap.entrySet();
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : set) {
            hashSet.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

