/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ListInvalidationListenerWrapper
implements ListChangeListener<Object> {
    private final ObservableList<?> observableList;
    private final InvalidationListener listener;

    public ListInvalidationListenerWrapper(ObservableList<?> observableList, InvalidationListener invalidationListener) {
        if (observableList == null) {
            throw new NullPointerException("ObservableList cannot be null.");
        }
        if (invalidationListener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        this.observableList = observableList;
        this.listener = invalidationListener;
    }

    @Override
    public void onChanged(ListChangeListener.Change<? extends Object> change) {
        this.listener.invalidated(this.observableList);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.listener == null ? 0 : this.listener.hashCode());
        n = 31 * n + (this.observableList == null ? 0 : this.observableList.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ListInvalidationListenerWrapper) {
            ListInvalidationListenerWrapper listInvalidationListenerWrapper = (ListInvalidationListenerWrapper)object;
            return this.listener.equals(listInvalidationListenerWrapper.listener) && this.observableList == listInvalidationListenerWrapper.observableList;
        }
        return false;
    }
}

