/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.jmx.SGMXBeanAccessor;
import com.sun.javafx.runtime.SystemProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.stage.Stage;

public class LauncherImpl {
    private static final boolean simulateSlowProgress = false;
    private static AtomicBoolean launchCalled = new AtomicBoolean(false);
    private static volatile RuntimeException launchException = null;
    private static Preloader currentPreloader = null;
    private static volatile boolean error = false;
    private static volatile Throwable pConstructorError = null;
    private static volatile Throwable pInitError = null;
    private static volatile Throwable pStartError = null;
    private static volatile Throwable pStopError = null;
    private static volatile Throwable constructorError = null;
    private static volatile Throwable initError = null;
    private static volatile Throwable startError = null;
    private static volatile Throwable stopError = null;
    private static Method notifyMethod = null;

    public static void launchApplication(Class<? extends Application> clazz, String[] stringArray) {
        LauncherImpl.launchApplication(clazz, null, stringArray);
    }

    public static void launchApplication(final Class<? extends Application> clazz, final Class<? extends Preloader> clazz2, final String[] stringArray) {
        if (launchCalled.getAndSet(true)) {
            throw new IllegalStateException("Application launch must not be called more than once");
        }
        if (!Application.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Error: " + clazz.getName() + " is not a subclass of javafx.application.Application");
        }
        if (clazz2 != null && !Preloader.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Error: " + clazz2.getName() + " is not a subclass of javafx.application.Preloader");
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LauncherImpl.launchApplication1(clazz, clazz2, stringArray);
                }
                catch (RuntimeException runtimeException) {
                    launchException = runtimeException;
                }
                catch (Exception exception) {
                    launchException = new RuntimeException("Application launch exception", exception);
                }
                catch (Error error) {
                    launchException = new RuntimeException("Application launch error", error);
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        thread.setName("JavaFX-Launcher");
        thread.start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unexpected exception: ", interruptedException);
        }
        if (launchException != null) {
            throw launchException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchApplication1(Class<? extends Application> clazz, Class<? extends Preloader> clazz2, String[] stringArray) throws Exception {
        boolean bl;
        PlatformImpl.FinishListener finishListener;
        block45: {
            if (SystemProperties.isDebug()) {
                SGMXBeanAccessor.registerSGMXBean();
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            PlatformImpl.startup(new Runnable(){

                @Override
                public void run() {
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            final AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
            final AtomicBoolean atomicBoolean3 = new AtomicBoolean(false);
            AtomicBoolean atomicBoolean4 = new AtomicBoolean(false);
            final CountDownLatch countDownLatch2 = new CountDownLatch(1);
            final CountDownLatch countDownLatch3 = new CountDownLatch(1);
            finishListener = new PlatformImpl.FinishListener(){

                @Override
                public void idle() {
                    if (atomicBoolean2.get()) {
                        countDownLatch2.countDown();
                    } else if (atomicBoolean.get()) {
                        countDownLatch3.countDown();
                    }
                }

                @Override
                public void exitCalled() {
                    atomicBoolean3.set(true);
                    countDownLatch2.countDown();
                }
            };
            PlatformImpl.addListener(finishListener);
            try {
                String string;
                boolean bl2;
                boolean bl3;
                Constructor<Application> constructor;
                Object object;
                Preloader preloader = null;
                if (clazz2 != null) {
                    try {
                        object = clazz2.getConstructor(new Class[0]);
                        preloader = ((Constructor)object).newInstance(new Object[0]);
                        ParametersImpl.registerParameters(preloader, new ParametersImpl(stringArray));
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in Preloader constructor");
                        pConstructorError = throwable;
                        error = true;
                    }
                }
                if ((currentPreloader = preloader) != null && !error && !atomicBoolean3.get()) {
                    try {
                        currentPreloader.init();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in Preloader init method");
                        pInitError = throwable;
                        error = true;
                    }
                }
                if (currentPreloader != null && !error && !atomicBoolean3.get()) {
                    PlatformImpl.runAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                atomicBoolean.set(true);
                                Stage stage = new Stage();
                                stage.impl_setPrimary(true);
                                currentPreloader.start(stage);
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Preloader start method");
                                pStartError = throwable;
                                error = true;
                            }
                        }
                    });
                    if (!error && !atomicBoolean3.get()) {
                        LauncherImpl.notifyProgress(currentPreloader, 0.0);
                    }
                }
                object = null;
                if (!error && !atomicBoolean3.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyProgress(currentPreloader, 1.0);
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_LOAD, null);
                    }
                    try {
                        constructor = clazz.getConstructor(new Class[0]);
                        object = constructor.newInstance(new Object[0]);
                        ParametersImpl.registerParameters((Application)object, new ParametersImpl(stringArray));
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in Application constructor");
                        constructorError = throwable;
                        error = true;
                    }
                }
                constructor = object;
                if (!error && !atomicBoolean3.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_INIT, constructor);
                    }
                    try {
                        ((Application)((Object)constructor)).init();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in Application init method");
                        initError = throwable;
                        error = true;
                    }
                }
                if (!error && !atomicBoolean3.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_START, constructor);
                    }
                    PlatformImpl.runAndWait(new Runnable((Application)((Object)constructor)){
                        final /* synthetic */ Application val$theApp;
                        {
                            this.val$theApp = application;
                        }

                        @Override
                        public void run() {
                            try {
                                atomicBoolean2.set(true);
                                Stage stage = new Stage();
                                stage.impl_setPrimary(true);
                                this.val$theApp.start(stage);
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Application start method");
                                startError = throwable;
                                error = true;
                            }
                        }
                    });
                }
                if (!error) {
                    countDownLatch2.await();
                }
                if (atomicBoolean2.get()) {
                    PlatformImpl.runAndWait(new Runnable((Application)((Object)constructor)){
                        final /* synthetic */ Application val$theApp;
                        {
                            this.val$theApp = application;
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$theApp.stop();
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Application stop method");
                                stopError = throwable;
                                error = true;
                            }
                        }
                    });
                }
                if ((bl3 = System.getProperty("os.name").startsWith("Mac")) && !(bl2 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return Boolean.getBoolean("javafx.keepalive");
                    }
                }).booleanValue())) {
                    if (constructorError != null) {
                        constructorError.printStackTrace();
                    } else if (initError != null) {
                        initError.printStackTrace();
                    } else if (startError != null) {
                        startError.printStackTrace();
                    } else if (stopError != null) {
                        stopError.printStackTrace();
                    }
                    System.err.println("JavaFX application launcher: calling System.exit");
                    System.exit(0);
                }
                if (!error) break block45;
                if (pConstructorError != null) {
                    throw new RuntimeException("Unable to construct Preloader instance: " + clazz, pConstructorError);
                }
                if (pInitError != null) {
                    throw new RuntimeException("Exception in Preloader init method", pInitError);
                }
                if (pStartError != null) {
                    throw new RuntimeException("Exception in Preloader start method", pStartError);
                }
                if (pStopError != null) {
                    throw new RuntimeException("Exception in Preloader stop method", pStopError);
                }
                if (constructorError != null) {
                    String string2 = "Unable to construct Application instance: " + clazz;
                    if (!LauncherImpl.notifyError(string2, constructorError)) {
                        throw new RuntimeException(string2, constructorError);
                    }
                    break block45;
                }
                if (initError != null) {
                    String string3 = "Exception in Application init method";
                    if (!LauncherImpl.notifyError(string3, initError)) {
                        throw new RuntimeException(string3, initError);
                    }
                    break block45;
                }
                if (startError != null) {
                    String string4 = "Exception in Application start method";
                    if (!LauncherImpl.notifyError(string4, startError)) {
                        throw new RuntimeException(string4, startError);
                    }
                    break block45;
                }
                if (stopError == null || LauncherImpl.notifyError(string = "Exception in Application stop method", stopError)) break block45;
                throw new RuntimeException(string, stopError);
            }
            catch (Throwable throwable) {
                boolean bl4;
                PlatformImpl.removeListener(finishListener);
                boolean bl5 = bl4 = System.getSecurityManager() != null;
                if (error && bl4) {
                    System.err.println("Workaround until RT-13281 is implemented: keep toolkit alive");
                } else {
                    PlatformImpl.tkExit();
                }
                throw throwable;
            }
        }
        PlatformImpl.removeListener(finishListener);
        boolean bl6 = bl = System.getSecurityManager() != null;
        if (error && bl) {
            System.err.println("Workaround until RT-13281 is implemented: keep toolkit alive");
        } else {
            PlatformImpl.tkExit();
        }
    }

    private static void notifyStateChange(final Preloader preloader, final Preloader.StateChangeNotification.Type type, final Application application) {
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                preloader.handleStateChangeNotification(new Preloader.StateChangeNotification(type, application));
            }
        });
    }

    private static void notifyProgress(final Preloader preloader, final double d) {
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                preloader.handleProgressNotification(new Preloader.ProgressNotification(d));
            }
        });
    }

    private static boolean notifyError(final String string, final Throwable throwable) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (currentPreloader != null) {
                    try {
                        Preloader.ErrorNotification errorNotification = new Preloader.ErrorNotification(null, string, throwable);
                        boolean bl = currentPreloader.handleErrorNotification(errorNotification);
                        atomicBoolean.set(bl);
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
        });
        return atomicBoolean.get();
    }

    private static void notifyCurrentPreloader(final Preloader.PreloaderNotification preloaderNotification) {
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (currentPreloader != null) {
                    currentPreloader.handleApplicationNotification(preloaderNotification);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPreloader(Application application, Preloader.PreloaderNotification preloaderNotification) {
        if (launchCalled.get()) {
            LauncherImpl.notifyCurrentPreloader(preloaderNotification);
            return;
        }
        Class<LauncherImpl> clazz = LauncherImpl.class;
        synchronized (LauncherImpl.class) {
            if (notifyMethod == null) {
                try {
                    Class<?> clazz2 = Class.forName("com.sun.deploy.uitoolkit.impl.fx.FXPreloader");
                    notifyMethod = clazz2.getMethod("notifyCurrentPreloader", Preloader.PreloaderNotification.class);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                notifyMethod.invoke(null, preloaderNotification);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    private LauncherImpl() {
        throw new InternalError();
    }
}

