/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDialogs {
    public static final List<File> showFileChooser(Window owner, File folder, String title, int type, boolean multipleMode, List<ExtensionFilter> extensionFilters) {
        String _folder = "";
        if (folder != null) {
            if (folder.isDirectory()) {
                _folder = folder.getAbsolutePath();
            } else {
                throw new IllegalArgumentException("Folder parameter must be a valid folder");
            }
        }
        if (title == null) {
            title = "";
        }
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Type parameter must be equal to one of the constants from Type");
        }
        ExtensionFilter[] _extensionFilters = null;
        if (extensionFilters != null) {
            _extensionFilters = extensionFilters.toArray(new ExtensionFilter[0]);
        }
        String[] _files = Application.GetApplication().staticCommonDialogs_showFileChooser(owner, _folder, title, type, multipleMode, _extensionFilters);
        ArrayList<File> files = new ArrayList<File>();
        for (String file : _files) {
            files.add(new File(file));
        }
        return files;
    }

    public static final File showFolderChooser() {
        String folder = Application.GetApplication().staticCommonDialogs_showFolderChooser();
        if (folder != null) {
            return new File(folder);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionFilter {
        private final String description;
        private final List<String> extensions;

        public ExtensionFilter(String description, List<String> extensions) {
            if (description == null || description.length() == 0) {
                throw new IllegalArgumentException("Description parameter must be non-null and not empty");
            }
            if (extensions == null || extensions.isEmpty()) {
                throw new IllegalArgumentException("Extensions parameter must be non-null and not empty");
            }
            for (String extension : extensions) {
                if (extension != null && extension.length() != 0) continue;
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            this.description = description;
            this.extensions = extensions;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        public String[] extensionsToArray() {
            return this.extensions.toArray(new String[0]);
        }
    }

    public static final class Type {
        public static final int OPEN = 0;
        public static final int SAVE = 1;
    }
}

