/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui.resources;

import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ResourceManager {
    private static ResourceBundle rbFX;
    private static ResourceBundle rbJRE;
    private static ResourceBundle rbMnemonicsFX;
    private static ResourceBundle rbMnemonicsJRE;

    static void reset() {
        rbFX = ResourceBundle.getBundle("com.sun.deploy.uitoolkit.impl.fx.ui.resources.Deployment");
        rbMnemonicsFX = ResourceBundle.getBundle("com.sun.deploy.uitoolkit.impl.fx.ui.resources.DeploymentMnemonics");
        try {
            rbJRE = ResourceBundle.getBundle("com.sun.deploy.resources.Deployment");
        }
        catch (MissingResourceException ex) {
            Trace.ignoredException((Exception)ex);
            rbJRE = rbFX;
        }
        try {
            rbMnemonicsJRE = ResourceBundle.getBundle("com.sun.deploy.resources.DeploymentMnemonics");
        }
        catch (MissingResourceException ex) {
            Trace.ignoredException((Exception)ex);
            rbMnemonicsJRE = rbMnemonicsFX;
        }
    }

    public static String getMessage(String key) {
        try {
            return rbFX.containsKey(key) ? rbFX.getString(key) : rbJRE.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static String getFormattedMessage(String key, Object[] args) {
        try {
            String formatStr = rbFX.containsKey(key) ? rbFX.getString(key) : rbJRE.getString(key);
            return new MessageFormat(formatStr).format(args);
        }
        catch (MissingResourceException ex) {
            Trace.ignoredException((Exception)ex);
            return key;
        }
    }

    public static String getString(String key) {
        try {
            return rbFX.containsKey(key) ? rbFX.getString(key) : rbJRE.getString(key);
        }
        catch (MissingResourceException mre) {
            Trace.ignoredException((Exception)mre);
            return null;
        }
    }

    public static String getString(String key, Object ... args) {
        return MessageFormat.format(ResourceManager.getString(key), args);
    }

    public static ImageView getIcon(final String key) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ImageView>(){

                @Override
                public ImageView run() {
                    return ResourceManager.getIcon_(key);
                }
            });
        }
        catch (Exception ex) {
            Trace.ignoredException((Exception)ex);
            return null;
        }
    }

    public static ImageView getIcon_(String key) {
        String resourceName = ResourceManager.getString(key);
        URL url = rbFX.getClass().getResource(resourceName);
        String className = rbFX.getClass().getName();
        if (url == null || key.equals("about.java.image")) {
            url = rbJRE.getClass().getResource(resourceName);
            className = rbJRE.getClass().getName();
        }
        return ResourceManager.getIcon(url);
    }

    public static ImageView getIcon(URL url) {
        Image image = new Image(url.toString());
        return new ImageView(image);
    }

    static {
        ResourceManager.reset();
    }
}

