/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import sun.misc.HexDumpEncoder;
import sun.security.x509.SerialNumber;

public class CertificateDialog {
    public static void showCertificates(Stage parent, Certificate[] certs, int start, int end) {
        final FXDialog details = new FXDialog(ResourceManager.getMessage("cert.dialog.caption"), parent, true);
        BorderPane borderPane = new BorderPane();
        details.setContentPane(borderPane);
        borderPane.setCenter(CertificateDialog.getComponents(parent, certs, start, end));
        FlowPane buttonPanel = new FlowPane();
        buttonPanel.setAlignment(Pos.TOP_LEFT);
        Button closeButton = new Button(ResourceManager.getMessage("cert.dialog.close"));
        closeButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                details.hide();
            }
        });
        buttonPanel.getChildren().add(closeButton);
        borderPane.setBottom(buttonPanel);
        details.show();
    }

    private static Node getComponents(Stage parent, Certificate[] certs, int start, int end) {
        SplitPane panel = new SplitPane();
        if (certs.length > start && certs[start] instanceof X509Certificate) {
            TreeView certChainTree = CertificateDialog.buildCertChainTree(certs, start, end);
            final TableView certInfoTable = new TableView();
            final TextArea textArea = new TextArea();
            textArea.setEditable(false);
            final MultipleSelectionModel treeSM = certChainTree.getSelectionModel();
            treeSM.getSelectedItems().addListener(new ListChangeListener<TreeItem<CertificateInfo>>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends TreeItem<CertificateInfo>> change) {
                    ObservableList selectedItems = treeSM.getSelectedItems();
                    if (selectedItems != null && selectedItems.size() == 1) {
                        TreeItem node = (TreeItem)selectedItems.get(0);
                        CertificateInfo certInfo = (CertificateInfo)node.getValue();
                        CertificateDialog.showCertificateInfo(certInfo.getCertificate(), certInfoTable, textArea);
                    }
                }
            });
            TableColumn<Row, Object> fieldColumn = new TableColumn<Row, Object>();
            fieldColumn.setText(ResourceManager.getMessage("cert.dialog.field"));
            fieldColumn.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>>(){

                @Override
                public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> p) {
                    return new ReadOnlyObjectWrapper<Object>(p.getValue().field);
                }
            });
            TableColumn<Row, Object> valueColumn = new TableColumn<Row, Object>();
            valueColumn.setText(ResourceManager.getMessage("cert.dialog.value"));
            valueColumn.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>>(){

                @Override
                public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> p) {
                    return new ReadOnlyObjectWrapper<Object>(p.getValue().value);
                }
            });
            certInfoTable.getColumns().addAll(fieldColumn, valueColumn);
            final TableView.TableViewSelectionModel tableSM = certInfoTable.getSelectionModel();
            tableSM.setSelectionMode(SelectionMode.SINGLE);
            tableSM.getSelectedItems().addListener(new ListChangeListener<String>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends String> change) {
                    ObservableList selectedItems = tableSM.getSelectedItems();
                    if (selectedItems != null && selectedItems.size() == 1) {
                        String value = ((Row)selectedItems.get((int)0)).value;
                        textArea.setText(value);
                    }
                }
            });
            panel.getItems().add(CertificateDialog.makeScrollPane(certChainTree));
            SplitPane panelInfo = new SplitPane();
            panelInfo.setOrientation(Orientation.VERTICAL);
            panelInfo.getItems().add(certInfoTable);
            textArea.setPrefWidth(320.0);
            textArea.setPrefHeight(120.0);
            panelInfo.getItems().add(CertificateDialog.makeScrollPane(textArea));
            panelInfo.setDividerPosition(0, 0.8);
            panel.getItems().add(panelInfo);
            panel.setDividerPosition(0, 0.4);
            treeSM.select(0);
        }
        return panel;
    }

    private static ScrollPane makeScrollPane(Node node) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent(node);
        if (node instanceof Label) {
            scrollPane.setFitToWidth(true);
        }
        return scrollPane;
    }

    private static TreeView buildCertChainTree(Certificate[] cert, int start, int end) {
        TreeItem<CertificateInfo> root = null;
        TreeItem<CertificateInfo> currentNode = null;
        for (int i = start; i < cert.length && i < end; ++i) {
            TreeItem<CertificateInfo> childNode = new TreeItem<CertificateInfo>(new CertificateInfo((X509Certificate)cert[i]));
            if (root == null) {
                root = childNode;
            } else {
                currentNode.getChildren().add(childNode);
            }
            currentNode = childNode;
        }
        TreeView<CertificateInfo> tree = new TreeView<CertificateInfo>();
        tree.setShowRoot(true);
        tree.setRoot(root);
        tree.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        return tree;
    }

    private static void showCertificateInfo(X509Certificate cert, TableView certInfoTable, TextArea textArea) {
        String certVersion = "V" + cert.getVersion();
        String certSerialNumber = "[xxxxx-xxxxx]";
        String md5 = null;
        String sha1 = null;
        try {
            SerialNumber serial = new SerialNumber(cert.getSerialNumber());
            certSerialNumber = "[" + serial.getNumber() + "]";
            md5 = CertificateDialog.getCertFingerPrint("MD5", cert);
            sha1 = CertificateDialog.getCertFingerPrint("SHA1", cert);
        }
        catch (Throwable e) {
            // empty catch block
        }
        String certSigAlg = "[" + cert.getSigAlgName() + "]";
        String certIssuer = CertificateDialog.formatDNString(((Object)cert.getIssuerDN()).toString());
        String certValidity = "[From: " + cert.getNotBefore() + ",\n To: " + cert.getNotAfter() + "]";
        String certSubject = CertificateDialog.formatDNString(((Object)cert.getSubjectDN()).toString());
        HexDumpEncoder encoder = new HexDumpEncoder();
        String certSig = encoder.encodeBuffer(cert.getSignature());
        ObservableList<Row> data = FXCollections.observableArrayList(new Row(ResourceManager.getMessage("cert.dialog.field.Version"), certVersion), new Row(ResourceManager.getMessage("cert.dialog.field.SerialNumber"), certSerialNumber), new Row(ResourceManager.getMessage("cert.dialog.field.SignatureAlg"), certSigAlg), new Row(ResourceManager.getMessage("cert.dialog.field.Issuer"), certIssuer), new Row(ResourceManager.getMessage("cert.dialog.field.Validity"), certValidity), new Row(ResourceManager.getMessage("cert.dialog.field.Subject"), certSubject), new Row(ResourceManager.getMessage("cert.dialog.field.Signature"), certSig), new Row(ResourceManager.getMessage("cert.dialog.field.md5Fingerprint"), md5), new Row(ResourceManager.getMessage("cert.dialog.field.sha1Fingerprint"), sha1));
        certInfoTable.setItems(data);
        certInfoTable.getSelectionModel().select(8, null);
    }

    public static String formatDNString(String dnString) {
        int len = dnString.length();
        boolean last = false;
        boolean inQuote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = dnString.charAt(i);
            if (ch == '\"' || ch == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (ch == ',' && !inQuote) {
                buffer.append(",\n");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String getCertFingerPrint(String mdAlg, X509Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return CertificateDialog.toHexString(digest);
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            CertificateDialog.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public static class CertificateInfo {
        X509Certificate cert;

        public CertificateInfo(X509Certificate cert) {
            this.cert = cert;
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }

        private String extractAliasName(X509Certificate cert) {
            String subjectName = ResourceManager.getMessage("security.dialog.unknown.subject");
            String issuerName = ResourceManager.getMessage("security.dialog.unknown.issuer");
            try {
                Principal principal = cert.getSubjectDN();
                Principal principalIssuer = cert.getIssuerDN();
                String subjectDNName = principal.getName();
                String issuerDNName = principalIssuer.getName();
                subjectName = this.extractFromQuote(subjectDNName, "CN=");
                if (subjectName == null) {
                    subjectName = this.extractFromQuote(subjectDNName, "O=");
                }
                if (subjectName == null) {
                    subjectName = ResourceManager.getMessage("security.dialog.unknown.subject");
                }
                if ((issuerName = this.extractFromQuote(issuerDNName, "CN=")) == null) {
                    issuerName = this.extractFromQuote(issuerDNName, "O=");
                }
                if (issuerName == null) {
                    issuerName = ResourceManager.getMessage("security.dialog.unknown.issuer");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            MessageFormat mf = new MessageFormat(ResourceManager.getMessage("security.dialog.certShowName"));
            Object[] args = new Object[]{subjectName, issuerName};
            return mf.format(args);
        }

        private String extractFromQuote(String s, String prefix) {
            if (s == null) {
                return null;
            }
            int x = s.indexOf(prefix);
            int y = 0;
            if (x >= 0) {
                if ((y = s.charAt(x += prefix.length()) == '\"' ? s.indexOf(34, ++x) : s.indexOf(44, x)) < 0) {
                    return s.substring(x);
                }
                return s.substring(x, y);
            }
            return null;
        }

        public String toString() {
            return this.extractAliasName(this.cert);
        }
    }

    private static class Row {
        public String field;
        public String value;

        Row(String field, String value) {
            this.field = field;
            this.value = value;
        }
    }
}

