﻿using System;

namespace IntegracaoPosSitef.Models
{
    public class RetornoTransacao
    {
        /// <summary>
        /// Código da empresa utilizado no SiTef.
        /// </summary>
        public String EMPRESA { get; set; }
        /// <summary>
        /// Identificação Terminal. Identificação do terminal utilizada no SiTef
        /// </summary>
        public String TERMINAL { get; set; }
        /// <summary>
        /// BANDEIRAS SITEF
        /// 00000 - OUTROS;
        /// 00001 - VISA;
        /// 00002 - MASTERCARD;
        /// 00003 - DINERS CLUB;
        /// 00004 - AMERICAN EXPRESS;
        /// 00005 - SOLLO;
        /// 00006 - Sidecard (Redecard);
        /// 00007 - Private Label (Redecard);
        /// 00008 - REDESHOP;
        /// 00009 - Pão de Açúcar;
        /// 00010 - Fininvest (Visanet);
        /// 00011 - JCB;
        /// 00012 - HIPERCARD;
        /// 00013 - AURA;
        /// 00014 - LOSANGO;
        /// 00015 - SOROCRED;
        /// 10014 - Discovery;
        /// </summary>
        public String BANDEIRA { get; set; }
        /// <summary>
        /// Código de autorização da transação de crédito. (Presente somente em transações com cartão de crédito).
        /// </summary>
        public String COD_AUTORIZACAO { get; set; }
        public String COD_CLIENTE { get; set; }
        public String COD_RESP { get; set; }
        /// <summary>
        ///  Código Transação. Indica código da transação realizada. Para transações que não se comunicam com autorizadores(ex: Reimpressão), este campo virá preenchido com "00".
        /// 00 - Consulta Cheque
        /// 01 - Cartão Débito
        /// 02 - Cartão Crédito
        /// </summary>
        public String CODTRANS { get; set; }
        public Object[] COMP_1VIA { get; set; }
        public Object[] COMP_2VIA { get; set; }
        public Object[] COMP_DADOS_CONF { get; set; }
        /// <summary>
        /// NSU do Host Autorizador
        /// </summary>
        public String NSU_HOST { get; set; }
        /// <summary>
        /// NSU do SiTef
        /// </summary>
        public String NSU_SITEF { get; set; }
        /// <summary>
        /// REDES SITEF
        /// 00000 - OUTROS;
        /// 00001 - TECBAN;
        /// 00002 - ITAU;
        /// 00003 - BRADESCO;
        /// 00004 - VISANET;
        /// 00005 - REDE;
        /// 00006 - AMEX;
        /// 00007 - SOLLO;
        /// 00008 - E CAPTURE;
        /// 00009 - SERASA;
        /// 00010 - SPC BRASIL;
        /// 00011 - SERASA DETALHADO;
        /// 00012 - TELEDATA;
        /// 00013 - ACSP;
        /// 00014 - ACSP DETALHADO;
        /// 00015 - TECBIZ;
        /// 00016 - CDL DF;
        /// 00017 - Repom;
        /// 00018 - STANDBY;
        /// 00019 - EDMCARD;
        /// 00020 - CREDICESTA;
        /// 00021 - BANRICOMPRAS;
        /// 00022 - ACC CARD;
        /// 00023 - Clubcard;
        /// 00024 - ACPR;
        /// 00025 - Vidalink;
        /// 00026 - CCC_WEB;
        /// 00027 - Ediguay;
        /// 00028 - Carrefour;
        /// 00029 - SOFTWAY;
        /// 00030 - MULTICHEQUE;
        /// 00031 - Ticket combustível;
        /// 00032 - YAMADA;
        /// 00033 - Citibank;
        /// 00034 - Infocard;
        /// 00035 - BESC;
        /// 00036 - EMS;
        /// 00037 - CHEQUE CASH;
        /// 00038 - CENTRAL CARD;
        /// 00039 - Drogaraia;
        /// 00040 - OUTRO SERVIÇO;
        /// 00041 - ACCOR;
        /// 00042 - EPAY GIFT;
        /// 00043 - Parati;
        /// 00044 - Tokoró;
        /// 00045 - COOPERCRED;
        /// 00046 - SERVCEL;
        /// 00047 - SOROCRED;
        /// 00048 - Vital;
        /// 00049 - SAX FINANCEIRA;
        /// 00050 - Formosa;
        /// 00051 - HIPERCARD;
        /// 00052 - Tricard;
        /// 00053 - CHECK OK;
        /// 00054 - POLICARD;
        /// 00055 - Cetelem Carrefour;
        /// 00056 - LEADER;
        /// 00057 - Consórcio Credicard Venezuela;
        /// 00058 - GAZINCRED;
        /// 00059 - TELENET;
        /// 00060 - Cheque Pré;
        /// 00061 - BRASIL CARD;
        /// 00062 - Epharma;
        /// 00063 - Total;
        /// 00064 - Consórcio Amex Venezuela;
        /// 00065 - GAX;
        /// 00066 - Peralta;
        /// 00067 - SERVIDOR PAGAMENTO;
        /// 00068 - BANESE;
        /// 00069 - RESOMAQ;
        /// 00070 - SYSDATA;
        /// 00071 - CDL POA;
        /// 00072 - BIGCARD;
        /// 00073 - DTRANSFER;
        /// 00074 - VIAVAREJO;
        /// 00075 - Check Express;
        /// 00076 - GIVEX;
        /// 00077 - Valecard;
        /// 00078 - Portal Card;
        /// 00079 - BANPARA;
        /// 00080 - SOFTNEX;
        /// 00081 - SuperCard;
        /// 00082 - GETNET;
        /// 00083 - PREVSAUDE;
        /// 00084 - BANCO POTTENCIAL;
        /// 00085 - SOPHUS;
        /// 00086 - MARISA 2;
        /// 00087 - MaxiCred;
        /// 00088 - BLACKHAWK;
        /// 00089 - EXPANSIVA;
        /// 00090 - SAS NT;
        /// 00091 - LEADER 2;
        /// 00092 - Somar;
        /// 00093 - CETELEM AURA;
        /// 00094 - CABAL;
        /// 00095 - CREDSYSTEM;
        /// 00096 - Banco Provincial;
        /// 00097 - CARTESYS;
        /// 00098 - CISA;
        /// 00099 - TRNCENTRE;
        /// 00100 - ACPR D;
        /// 00101 - CARDCO;
        /// 00102 - CHECK CHECK;
        /// 00103 - CADASA;
        /// 00104 - PRIVATE BRADESCO;
        /// 00105 - CREDMAIS;
        /// 00106 - GWCEL;
        /// 00107 - CHECK EXPRESS 2;
        /// 00108 - GETNET PBM;
        /// 00109 - USECRED;
        /// 00110 - SERV VOUCHER;
        /// 00111 - TREDENEXX;
        /// 00112 - Bonus Presente Carrefour;
        /// 00113 - CREDISHOP;
        /// 00114 - ESTAPAR;
        /// 00115 - Banco Ibi;
        /// 00116 - WORKERCARD;
        /// 00117 - Telecheque;
        /// 00118 - OBOE;
        /// 00119 - PROTEGE;
        /// 00120 - SERASA CARDS;
        /// 00121 - Hotcard;
        /// 00122 - Banco Panamericano;
        /// 00123 - Banco Mercantil;
        /// 00124 - Sigacred;
        /// 00125 - CIELO;
        /// 00126 - SPTRANS;
        /// 00127 - PRESENTE MARISA;
        /// 00128 - COOPLIFE;
        /// 00129 - BOD;
        /// 00130 - G CARD;
        /// 00131 - TCREDIT;
        /// 00132 - Siscred;
        /// 00133 - FOXWINCARDS;
        /// 00134 - CONVCARD;
        /// 00135 - Voucher;
        /// 00136 - EXPAND CARDS;
        /// 00137 - ULTRAGAZ;
        /// 00138 - Qualicard;
        /// 00139 - HSBC UK;
        /// 00140 - WAPPA;
        /// 00141 - SQCF;
        /// 00142 - INTELLISYS;
        /// 00143 - BOD DÉBITO;
        /// 00144 - ACCREDITO;
        /// 00145 - COMPROCARD;
        /// 00146 - ORGCARD;
        /// 00147 - MINASCRED;
        /// 00148 - Farmácia Popular;
        /// 00149 - Fidelidade Mais;
        /// 00150 - ITAÚ SHOPLINE;
        /// 00151 - CDL RIO;
        /// 00152 - FORTCARD;
        /// 00153 - PAGGO;
        /// 00154 - SMARTNET;
        /// 00155 - INTERFARMACIA;
        /// 00156 - VALECON;
        /// 00157 - CARTÃO EVANGÉLICO;
        /// 00158 - VEGASCARD;
        /// 00159 - SCCARD;
        /// 00160 - ORBITALL;
        /// 00161 - ICARDS;
        /// 00162 - FACILCARD;
        /// 00163 - Fidelize;
        /// 00164 - FINAMAX;
        /// 00165 - BANCO GE;
        /// 00166 - UNIK;
        /// 00167 - TIVIT;
        /// 00168 - VALIDATA;
        /// 00169 - BANESCARD;
        /// 00170 - CSU CARREFOUR;
        /// 00171 - Valeshop;
        /// 00172 - SOMAR CARD;
        /// 00173 - OMNION;
        /// 00174 - CONDOR;
        /// 00175 - STANDBYDUP;
        /// 00176 - BPAG BOLDCRON;
        /// 00177 - MARISA SAX SYSIN;
        /// 00178 - STARFICHE;
        /// 00179 - ACE SEGUROS;
        /// 00180 - TOP CARD;
        /// 00181 - GETNET LAC;
        /// 00182 - UP SIGHT;
        /// 00183 - MAR;
        /// 00184 - Funcional Card;
        /// 00185 - PHARMA SYSTEM;
        /// 00186 - NEUS;
        /// 00187 - SICREDI;
        /// 00188 - ESCALENA;
        /// 00189 - N SERVIÇOS;
        /// 00190 - CSF CARREFOUR;
        /// 00191 - ATP;
        /// 00192 - AVST;
        /// 00193 - ALGORIX;
        /// 00194 - AMEX EMV;
        /// 00195 - COMPREMAX;
        /// 00196 - LIBERCARD;
        /// 00197 - SEICON;
        /// 00198 - SERASA AUTORIZ CRÉDITO;
        /// 00199 - SMARTN;
        /// 00200 - PLATCO;
        /// 00201 - SMARTNET EMV;
        /// 00202 - PROSA MÉXICO;
        /// 00203 - PEELA;
        /// 00204 - NUTRIK;
        /// 00205 - GOLDENFARMA PBM;
        /// 00206 - GLOBAL PAYMENTS;
        /// 00207 - ELAVON;
        /// 00208 - CTF;
        /// 00209 - BANESTIK;
        /// 00210 - VISA ARG;
        /// 00211 - AMEX ARG;
        /// 00212 - POSNET ARG;
        /// 00213 - AMEX MÉXICO;
        /// 00214 - ELETROZEMA;
        /// 00215 - BARIGUI;
        /// 00216 - SIMEC;
        /// 00217 - SGF;
        /// 00218 - HUG;
        /// 00219 - CARTÃO CONSIGNUM CARTÃO METTACARD;
        /// 00220 - DDTOTAL;
        /// 00221 - CARTÃO QUALIDADE;
        /// 00222 - REDECONV;
        /// 00223 - NUTRICARD;
        /// 00224 - DOTZ;
        /// 00225 - PREMIAÇÕES RAIZEN;
        /// 00226 - TROCO SOLIDÁRIO;
        /// 00227 - AMBEV SÓCIO TORCEDOR;
        /// 00228 - SEMPRE;
        /// 00229 - FIRST DATA;
        /// 00230 - COCIPA;
        /// 00231 - IBI MÉXICO;
        /// 00232 - SIANET;
        /// 00233 - SGCARDS;
        /// 00234 - CIAGROUP;
        /// 00235 - FILLIP;
        /// 00236 - Conductor;
        /// 00237 - LTM RAIZEN;
        /// 00238 - INCOMM;
        /// 00239 - VISA PASS FIRST;
        /// 00240 - CENCOSUD;
        /// 00241 - HIPERLIFE;
        /// 00242 - SITPOS;
        /// 00243 - AGT;
        /// 00244 - MIRA;
        /// 00245 - AMBEV 2 SÓCIO TORCEDOR;
        /// 00246 - JGV;
        /// 00247 - CREDSAT;
        /// 00248 - BRAZILIAN CARD;
        /// 00249 - RIACHUELO;
        /// 00250 - ITS RAIZEN;
        /// 00251 - SIMCRED;
        /// 00252 - BANCRED CARD;
        /// 00253 - CONEKTA;
        /// 00254 - SOFTCARD;
        /// 00255 - ECOPAG;
        /// 00256 - C&A AUTOMAÇÃO IBI;
        /// 00257 - C&A PARCERIAS BRADESCARD;
        /// 00258 - OGLOBA;
        /// 00259 - BANESE VOUCHER;
        /// 00260 - RAPP;
        /// 00261 - Monitora POS;
        /// 00262 - SOLLUS;
        /// 00263 - FITCARD;
        /// 00264 - ADIANTI;
        /// 00265 - STONE;
        /// 00266 - DMCARD;
        /// 00267 - ICATU 2;
        /// </summary>
        public String REDE_AUT { get; set; }
        /// <summary>
        /// Tipo de Parcelamento
        /// "00": À vista 
        /// "01": Pré-Datado
        /// "02": Parcelado Estabelecimento
        /// "03": Parcelado Administradora
        /// 
        /// OS CODIGOS DO SISTEMA SÃO:
        /// 0000 - Cheque À vista;
        /// 0001 - Cheque Pré-datado;
        /// 0002 - Cheque Parcelado com financiamento pelo estabeleci;
        /// 0003 - Cheque Parcelado com financiamento pela administra;
        /// 0099 - Cheque Outro tipo de pagamento;
        /// 0100 - Débito à vista;
        /// 0101 - Débito predatado;
        /// 0102 - Cartão de Débito Parcelado com financiamento pelo;
        /// 0103 - Cartão de Débito Parcelado com financiamento pela;
        /// 0199 - Cartão de Débito Outro tipo de pagamento;
        /// 0200 - Crédito à vista;
        /// 0201 - Cartão de Crédito Pré-datado;
        /// 0202 - Crédito Parcelado Financiamento Estabelecimento;
        /// 0203 - Crédido Parcelado Financiamento Administradora;
        /// 0299 - Cartão de Crédito Outro tipo de pagamento;
        /// 0300 - Cartão Tipo Voucher;
        /// 0301 - Cartão tipo Voucher Pré-datado;
        /// 0303 - Cartão tipo Voucher Parcelado com financiamento pe;
        /// 0399 - Cartão tipo Voucher Outro tipo de pagamento;
        /// 9800 - Dinheiro À vista;
        /// 9801 - Dinheiro Pré-datado;
        /// 9802 - Dinheiro Parcelado com financiamento pelo estabele;
        /// 9803 - Dinheiro Parcelado com financiamento pela administ;
        /// 9899 - Dinheiro Outro tipo de pagamento;
        /// 9900 - Outro tipo de cartão À vista;
        /// 9901 - Outro tipo de cartão Pré-datado;
        /// 9902 - Outro tipo de cartão Parcelado com financiamento p;
        /// 9999 - Outro tipo de cartão Outro tipo de pagamento;
        /// </summary>
        public String TIPO_PARC { get; set; }
        public int CODRESP { get; set; }
        public int COMP_CUPOM_FISCAL { get; set; }
        public int COMP_DATA_FISCAL { get; set; }
        public int COMP_HORA_FISCAL { get; set; }
        public int NUM_PARC { get; set; }
        /// <summary>
        /// Tipo de Transação a ser realizada. Se o valor não tiver sido definido, será adotado o valor 1.
        /// 1 - Transação Financeira
        /// 2 - Transação Administrativa
        /// 3 - Transação Direta
        /// </summary>
        public int TIPO_TRN { get; set; }
        public decimal VALOR { get; set; }
        public decimal VLRTROCO { get; set; }
        /// <summary>
        /// Informações Adicionais. Os mesmos campos (com os mesmos valores) que foram enviados para o browser. (id_abastecimento) 
        /// </summary>
        public int SAC_01 { get; set; }
        //idUsuarioLogado
        public string SAC_02 { get; set; }
        //idAtendenteLogado
        public string SAC_03 { get; set; }

        public string RedeAutNome { get; set; }
        public string BandeiraNome { get; set; }
        public string CodRespNome { get; set; }
        public string CodTransNome { get; set; }
        public string CompHoraCupom { get; set; }
        public string CompDataCupom { get; set; }
        public bool EmitirVenda { get; set; }
        public bool TransacaoAprovada { get; set; }
		public string ViaEstabeleciomento = "VIA ESTABELECIMENTO                       ";
        public string ViaCliente = "VIA CLIENTE                               ";
        public string CNPJEstabelecimento { get; set; } = string.Empty;
        public string Comp1Linha1 { get; set; } = string.Empty;
        public string Comp1Linha2 { get; set; } = string.Empty;
        public string Comp1Linha3 { get; set; } = string.Empty;
        public string Comp1Linha4 { get; set; } = string.Empty;
        public string Comp1Linha5 { get; set; } = string.Empty;
        public string Comp1Linha6 { get; set; } = string.Empty;
        public string Comp1Linha7 { get; set; } = string.Empty;
        public string Comp1Linha8 { get; set; } = string.Empty;
        public string Comp1Linha9 { get; set; } = string.Empty;
        public string Comp1Linha10 { get; set; } = string.Empty;
        public string Comp1Linha11 { get; set; } = string.Empty;
        public string Comp1Linha12 { get; set; } = string.Empty;
        public string Comp1Linha13 { get; set; } = string.Empty;
        public string Comp1Linha14 { get; set; } = string.Empty;
        public string Comp1Linha15 { get; set; } = string.Empty;
        public string Comp1Linha16 { get; set; } = string.Empty;
        public string Comp1Linha17 { get; set; } = string.Empty;
        public string Comp1Linha18 { get; set; } = string.Empty;
        public string Comp1Linha19 { get; set; } = string.Empty;
        public string Comp1Linha20 { get; set; } = string.Empty;
        public string Comp2Linha1 { get; set; } = string.Empty;
        public string Comp2Linha2 { get; set; } = string.Empty;
        public string Comp2Linha3 { get; set; } = string.Empty;
        public string Comp2Linha4 { get; set; } = string.Empty;
        public string Comp2Linha5 { get; set; } = string.Empty;
        public string Comp2Linha6 { get; set; } = string.Empty;
        public string Comp2Linha7 { get; set; } = string.Empty;
        public string Comp2Linha8 { get; set; } = string.Empty;
        public string Comp2Linha9 { get; set; } = string.Empty;
        public string Comp2Linha10 { get; set; } = string.Empty;
        public string Comp2Linha11 { get; set; } = string.Empty;
        public string Comp2Linha12 { get; set; } = string.Empty;
        public string Comp2Linha13 { get; set; } = string.Empty;
        public string Comp2Linha14 { get; set; } = string.Empty;
        public string Comp2Linha15 { get; set; } = string.Empty;
        public string Comp2Linha16 { get; set; } = string.Empty;
        public string Comp2Linha17 { get; set; } = string.Empty;
        public string Comp2Linha18 { get; set; } = string.Empty;
        public string Comp2Linha19 { get; set; } = string.Empty;
        public string Comp2Linha20 { get; set; } = string.Empty;
    }
}