﻿using System;
using System.Web;

namespace IntegracaoPosSitef.Controllers
{
    public class AutenticadorController : IHttpHandler
    {
        string userAgent = HttpContext.Current.Request.UserAgent;
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();

        public bool validaBrowser()
        {
            logger.Trace(string.Empty);
            logger.Trace("userAgent=" + userAgent);
#if DEBUG
            if (userAgent.Contains("Chrome"))
            {
                logger.Debug("POS válido.");
                return true;
            }
#endif
            if (userAgent.Contains("Browser_POS-SiTef") || userAgent.Contains("Browser POS-SiTef"))
            {
                logger.Debug("POS válido.");
                return true;
            }
            else
            {
                logger.Debug("POS inválido.");
                return false;
            }
        }

        public string[] buscaNumeroIdentificacaoTerminal()
        {
            logger.Trace(string.Empty);

            string idTerminalOld = userAgent.ToString().Substring(52, 9).ToUpper();
            string[] identificacaoCompleta = userAgent.ToString().ToUpper().Trim().Split('/');

            string idTerminalNew = string.Empty;
            if (identificacaoCompleta.Length >= 4)
                idTerminalNew = identificacaoCompleta[3];


            string[] listaIdentificadoresAutenticacao;
            if (!idTerminalNew.Equals(string.Empty))
            {
                listaIdentificadoresAutenticacao = new string[] { idTerminalOld, idTerminalNew };
            }
            else
            {
                listaIdentificadoresAutenticacao = new string[] { idTerminalOld };
            }

            logger.Debug("POS a ser autenticado =[");

            foreach (string identificacao in listaIdentificadoresAutenticacao)
                logger.Debug(identificacao);

			logger.Debug("]");

			return listaIdentificadoresAutenticacao;
        }

        public bool IsReusable
        {
            get { throw new NotImplementedException(); }
        }

        public void ProcessRequest(HttpContext context)
        {
            logger.Trace(string.Empty);

            throw new NotImplementedException();
        }
    }
}
